/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.zoom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.styling.zoom.MedialZoomContext;

public class ListZoomContext
extends MedialZoomContext {
    final List<Double> scales;
    final int initial;

    public static void validate(List<Double> scales) {
        double last = Double.POSITIVE_INFINITY;
        for (double x : scales) {
            if (x >= last) {
                throw new IllegalArgumentException("Scale denominator list must be decreasing");
            }
            if (x <= 0.0) {
                throw new IllegalArgumentException("Scale Denominators must be positive");
            }
            if (!Double.isInfinite(x) && !Double.isNaN(x)) continue;
            throw new IllegalArgumentException("Scale Denominators must be finite");
        }
    }

    public ListZoomContext(List<Double> scales, int initial) {
        ListZoomContext.validate(scales);
        this.scales = Collections.unmodifiableList(new ArrayList<Double>(scales));
        this.initial = initial;
    }

    public ListZoomContext(List<Double> scales) {
        this(scales, 0);
    }

    @Override
    public double getScaleDenominator(int level) {
        int i = level - this.initial;
        if (i < 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (i >= this.scales.size()) {
            return 0.0;
        }
        return this.scales.get(i);
    }

    @Override
    public double getMedialScale(int level) {
        double scale = this.getScaleDenominator(level);
        double nextScale = this.getScaleDenominator(level + 1);
        if (nextScale == 0.0) {
            return 0.0;
        }
        return Math.sqrt(scale * nextScale);
    }

    @Override
    public boolean isInRange(int level) {
        return level >= this.initial && level - this.initial < this.scales.size();
    }
}

