/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.lowagie.text.DocumentException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.output.AbstractImageFormat;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.OutputFormatFactory;
import org.mapfish.print.output.PrintParams;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class NativeProcessOutputFactory
implements OutputFormatFactory {
    public static final Logger LOGGER = LogManager.getLogger(NativeProcessOutputFactory.class);
    private String cmd;
    private List<String> cmdArgs = new ArrayList<String>();
    private List<String> formats = new ArrayList<String>();
    private int timeoutSeconds = 30;
    private final Semaphore runningProcesses;

    public NativeProcessOutputFactory(int maxProcesses) {
        this.runningProcesses = new Semaphore(maxProcesses, true);
        this.cmd = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase().contains("win") ? "convert" : "/usr/bin/convert";
        this.cmdArgs.add("-density");
        this.cmdArgs.add("@@dpi@@x@@dpi@@");
        this.cmdArgs.add("-append");
        this.cmdArgs.add("@@sourceFile@@");
        this.cmdArgs.add("@@targetFile@@");
        this.formats.add("jpg");
        this.formats.add("gif");
        this.formats.add("png");
        this.formats.add("bmp");
        this.formats.add("tif");
        this.formats.add("tiff");
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public void setCmdArgs(List<String> cmdArgs) {
        this.cmdArgs = cmdArgs;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public void setFormats(List<String> formats) {
        this.formats = formats;
    }

    @Override
    public List<String> formats() {
        return this.formats;
    }

    @Override
    public OutputFormat create(String format) {
        return new ImageOutput(format);
    }

    @Override
    public String enablementStatus() {
        return null;
    }

    private class ImageOutput
    extends AbstractImageFormat {
        public ImageOutput(String format) {
            super(format);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RenderingContext print(PrintParams params) throws DocumentException, InterruptedException {
            PJsonArray layers = params.jsonSpec.getJSONArray("layers");
            double a = -0.3;
            double b = 0.9;
            double c = 0.4;
            for (int i = 0; i < layers.size(); ++i) {
                PJsonObject layer = layers.getJSONObject(i);
                if (!layer.has("opacity")) continue;
                double opacity = layer.getDouble("opacity");
                opacity = -0.3 * opacity * opacity + 0.9 * opacity + 0.4;
                try {
                    layer.getInternalObj().put("opacity", opacity);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            File tmpPdfFile = null;
            File tmpImageFile = null;
            try {
                RenderingContext context;
                tmpPdfFile = File.createTempFile("mapfishprint", ".pdf");
                try (FileOutputStream tmpOut = new FileOutputStream(tmpPdfFile);){
                    context = this.doPrint(params.withOutput(tmpOut));
                }
                String suffix = "." + this.format;
                tmpImageFile = File.createTempFile("mapfishprint", suffix);
                this.createImage(params.jsonSpec, tmpPdfFile, tmpImageFile, context);
                this.drawImage(params.outputStream, tmpImageFile);
                RenderingContext renderingContext = context;
                return renderingContext;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (tmpPdfFile != null) {
                    if (!tmpPdfFile.delete()) {
                        LOGGER.warn(tmpPdfFile + " was not able to be deleted for unknown reason.  Will try again on shutdown");
                    }
                    tmpPdfFile.deleteOnExit();
                }
                if (tmpImageFile != null) {
                    if (!tmpImageFile.delete()) {
                        LOGGER.warn(tmpImageFile + " was not able to be deleted for unknown reason.  Will try again on shutdown");
                    }
                    tmpImageFile.deleteOnExit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawImage(OutputStream out, File tmpPngFile) throws IOException {
            FileInputStream inputStream = new FileInputStream(tmpPngFile);
            FileChannel channel = inputStream.getChannel();
            try {
                channel.transferTo(0L, tmpPngFile.length(), Channels.newChannel(out));
            }
            finally {
                this.closeQuiet(channel);
                this.closeQuiet(inputStream);
            }
        }

        private void closeQuiet(Closeable c) {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Error closing resource", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createImage(PJsonObject jsonSpec, File tmpPdfFile, File tmpPngFile, RenderingContext context) throws IOException, InterruptedException {
            block7: {
                NativeProcessOutputFactory.this.runningProcesses.tryAcquire(NativeProcessOutputFactory.this.timeoutSeconds, TimeUnit.SECONDS);
                try {
                    int dpi = this.calculateDPI(context, jsonSpec);
                    String[] finalCommands = new String[NativeProcessOutputFactory.this.cmdArgs.size() + 1];
                    finalCommands[0] = NativeProcessOutputFactory.this.cmd;
                    for (int i = 1; i < finalCommands.length; ++i) {
                        String arg;
                        finalCommands[i] = arg = NativeProcessOutputFactory.this.cmdArgs.get(i - 1).replace("@@dpi@@", "" + dpi).replace("@@targetFile@@", tmpPngFile.getAbsolutePath()).replace("@@sourceFile@@", tmpPdfFile.getAbsolutePath()).replace("${dpi}", "" + dpi).replace("${targetFile}", tmpPngFile.getAbsolutePath()).replace("${sourceFile}", tmpPdfFile.getAbsolutePath());
                    }
                    ProcessBuilder builder = new ProcessBuilder(finalCommands);
                    LOGGER.info("Executing process: " + builder.command());
                    Process p = builder.start();
                    this.writeOut(p, false);
                    this.writeOut(p, true);
                    try {
                        int exitCode = p.waitFor();
                        p.destroy();
                        if (exitCode != 0) {
                            LOGGER.error(NativeProcessOutputFactory.this.cmd + " failed to create image from pdf.  Exit code was " + exitCode);
                            break block7;
                        }
                        LOGGER.info(NativeProcessOutputFactory.this.cmd + " exited correctly from image conversion process.  Exit code was " + exitCode);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Process interrupted", (Throwable)e);
                    }
                }
                finally {
                    NativeProcessOutputFactory.this.runningProcesses.release();
                }
            }
        }

        private void writeOut(Process p, boolean errorStream) throws IOException {
            InputStream stream = errorStream ? p.getErrorStream() : p.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (errorStream) {
                    LOGGER.error(line);
                    continue;
                }
                LOGGER.info(line);
            }
        }
    }
}

