/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.readers.TileableMapReader;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.DistanceUnit;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class KaMapCacheMapReader
extends TileableMapReader {
    private final String map;
    private final String group;
    private final String units;
    private final int metaTileWidth;
    private final int metaTileHeight;

    private KaMapCacheMapReader(String map, String group, String units, int metaTileWidth, int metaTileHeight, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.map = map;
        this.group = group;
        this.units = units;
        this.metaTileWidth = metaTileWidth;
        this.metaTileHeight = metaTileHeight;
        PJsonArray maxExtent = params.getJSONArray("maxExtent");
        PJsonArray tileSize = params.getJSONArray("tileSize");
        this.tileCacheLayerInfo = new TileCacheLayerInfo(params.getJSONArray("resolutions"), tileSize.getInt(0), tileSize.getInt(1), maxExtent.getFloat(0), maxExtent.getFloat(1), maxExtent.getFloat(2), maxExtent.getFloat(3), params.getString("extension"));
    }

    @Override
    protected TileRenderer.Format getFormat() {
        return TileRenderer.Format.BITMAP;
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
    }

    @Override
    protected URI getTileUri(URI commonUri, Transformer transformer, double minGeoX, double minGeoY, double maxGeoX, double maxGeoY, long w, long h) throws URISyntaxException, UnsupportedEncodingException {
        double targetResolution = (maxGeoX - minGeoX) / (double)w;
        TileCacheLayerInfo.ResolutionInfo resolution = this.tileCacheLayerInfo.getNearestResolution(targetResolution);
        DistanceUnit unitEnum = DistanceUnit.fromString(this.units);
        if (unitEnum == null) {
            throw new RuntimeException("Unknown unit: '" + this.units + "'");
        }
        double scale = this.context.getConfig().getBestScale(Math.max((maxGeoX - minGeoX) / DistanceUnit.PT.convertTo(w, unitEnum), (maxGeoY - minGeoY) / DistanceUnit.PT.convertTo(h, unitEnum)));
        double pX = Math.round(minGeoX / resolution.value);
        double pY = Math.round(maxGeoY / resolution.value) * -1L;
        pX = Math.floor(pX / (double)w) * (double)w;
        pY = Math.floor(pY / (double)h) * (double)h;
        int pX4Path = (int)pX;
        int pY4Path = (int)pY;
        long metaX = (long)Math.floor(pX / (double)w / (double)this.metaTileWidth) * w * (long)this.metaTileWidth;
        long metaY = (long)Math.floor(pY / (double)h / (double)this.metaTileHeight) * h * (long)this.metaTileHeight;
        StringBuilder path = new StringBuilder();
        if (!commonUri.getPath().endsWith("/")) {
            path.append('/');
        }
        path.append(this.map);
        path.append('/').append(scale);
        path.append('/').append(this.group).append("");
        path.append("/def");
        path.append("/t").append(metaY);
        path.append("/l").append(metaX);
        path.append("/t").append(pY4Path).append('l').append(pX4Path).append('.').append(this.tileCacheLayerInfo.getExtension());
        return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), commonUri.getPath() + path.toString(), commonUri.getQuery(), commonUri.getFragment());
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.map;
    }

    public static class Factory
    implements MapReaderFactory {
        public List<MapReader> create(String type, RenderingContext context, PJsonObject params) {
            ArrayList<MapReader> target = new ArrayList<MapReader>();
            String map = params.getString("map");
            String group = params.getString("group");
            int metaTileWidth = params.getInt("metaTileWidth");
            int metaTileHeight = params.getInt("metaTileHeight");
            String units = context.getGlobalParams().getString("units");
            target.add(new KaMapCacheMapReader(map, group, units, metaTileWidth, metaTileHeight, context, params));
            return target;
        }
    }
}

