/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.config.AcceptAllMatcher;

public abstract class HostMatcher {
    public static final HostMatcher ACCEPT_ALL = new AcceptAllMatcher();
    protected int port = -1;
    protected String pathRegex = null;

    public boolean validate(URI uri) throws UnknownHostException, SocketException, MalformedURLException {
        Matcher matcher;
        int uriPort = uri.getPort();
        if (uriPort < 0) {
            uriPort = uri.toURL().getDefaultPort();
        }
        if (this.port > 0 && uriPort != this.port) {
            return false;
        }
        return this.pathRegex == null || (matcher = Pattern.compile(this.pathRegex).matcher(uri.getPath())).matches();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPathRegex(String pathRegex) {
        this.pathRegex = pathRegex;
    }

    public abstract String toString();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pathRegex == null ? 0 : this.pathRegex.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostMatcher other = (HostMatcher)obj;
        if (this.pathRegex == null ? other.pathRegex != null : !this.pathRegex.equals(other.pathRegex)) {
            return false;
        }
        return this.port == other.port;
    }
}

