/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class TimeLogger {
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    private final Logger logger;
    private final Level level;
    private final String task;
    private long start;

    private static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    private TimeLogger(Logger logger, Level level, String task) {
        this.logger = logger;
        this.level = level;
        this.task = task;
        this.log("Starting '" + task + "' at " + TimeLogger.now());
        this.start = System.currentTimeMillis();
    }

    private void log(String s) {
        if (this.level.equals((Object)Level.DEBUG)) {
            this.logger.debug(s);
        } else if (this.level.equals((Object)Level.ERROR)) {
            this.logger.error(s);
        } else if (this.level.equals((Object)Level.FATAL)) {
            this.logger.fatal(s);
        } else if (this.level.equals((Object)Level.WARN)) {
            this.logger.warn(s);
        } else {
            this.logger.info(s);
        }
    }

    public void done() {
        long time = System.currentTimeMillis() - this.start;
        this.log("Finished '" + this.task + "' after " + time + " ms");
    }

    public static TimeLogger info(Logger logger, String task) {
        return new TimeLogger(logger, Level.INFO, task);
    }

    public static TimeLogger debug(Logger logger, String task) {
        return new TimeLogger(logger, Level.DEBUG, task);
    }
}

