/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.responses;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fao.geonet.domain.ISODate;
import org.fao.oaipmh.OaiPmh;
import org.fao.oaipmh.util.Lib;
import org.jdom.Element;

public class Header {
    private String identifier;
    private ISODate dateStamp;
    private boolean deleted;
    private List<String> sets = new ArrayList<String>();

    public Header() {
    }

    public Header(Element header) {
        this.build(header);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public ISODate getDateStamp() {
        return this.dateStamp;
    }

    public void setDateStamp(ISODate dateStamp) {
        this.dateStamp = dateStamp;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean yesno) {
        this.deleted = yesno;
    }

    public Iterator<String> getSets() {
        return this.sets.iterator();
    }

    public void clearSets() {
        this.sets.clear();
    }

    public void addSet(String set) {
        this.sets.add(set);
    }

    public Element toXml() {
        Element header = new Element("header", OaiPmh.Namespaces.OAI_PMH);
        Lib.add(header, "identifier", this.identifier);
        Lib.add(header, "datestamp", this.dateStamp.getDateAndTime());
        for (String set : this.sets) {
            Lib.add(header, "setSpec", set);
        }
        if (this.deleted) {
            header.setAttribute("status", "deleted");
        }
        return header;
    }

    private void build(Element header) {
        Element ident = header.getChild("identifier", OaiPmh.Namespaces.OAI_PMH);
        Element date = header.getChild("datestamp", OaiPmh.Namespaces.OAI_PMH);
        String status = header.getAttributeValue("status");
        this.identifier = ident.getText();
        this.dateStamp = new ISODate(date.getText());
        this.deleted = status != null;
        for (Object o : header.getChildren("setSpec", OaiPmh.Namespaces.OAI_PMH)) {
            Element set = (Element)o;
            this.sets.add(set.getText());
        }
    }
}

