/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.reports;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDataInfo_;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.OperationAllowed_;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.User_;
import org.springframework.data.jpa.domain.Specification;

public class MetadataReportsQueries {
    private final EntityManager _entityManager;

    public MetadataReportsQueries(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public List<? extends AbstractMetadata> getUpdatedMetadata(ISODate dateFrom, ISODate dateTo, Set<Integer> groups) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(Metadata.class);
        Root metadataRoot = cbQuery.from(Metadata.class);
        Root userRoot = cbQuery.from(User.class);
        Path userOwnerPath = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.owner);
        Path groupOwnerPath = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner);
        Path userIdPath = userRoot.get(User_.id);
        Predicate ownerPredicate = cb.equal((Expression)userOwnerPath, (Expression)userIdPath);
        Path changeDate = metadataRoot.get(Metadata_.dataInfo).get(MetadataDataInfo_.changeDate);
        Predicate datePredicate = cb.and((Expression)cb.lessThanOrEqualTo((Expression)changeDate, (Comparable)dateTo), (Expression)cb.greaterThanOrEqualTo((Expression)changeDate, (Comparable)dateFrom));
        Path template = metadataRoot.get(Metadata_.dataInfo).get(MetadataDataInfo_.type_JPAWorkaround);
        Predicate templatePredicate = cb.equal((Expression)template, (Object)Character.valueOf('n'));
        if (!groups.isEmpty()) {
            Predicate inGroups = groupOwnerPath.in(groups);
            cbQuery.select((Selection)metadataRoot).where((Expression)cb.and((Expression)cb.and(new Predicate[]{ownerPredicate, datePredicate, templatePredicate}), (Expression)inGroups));
        } else {
            cbQuery.select((Selection)metadataRoot).where((Expression)cb.and(new Predicate[]{cb.and(new Predicate[]{ownerPredicate, datePredicate, templatePredicate})}));
        }
        cbQuery.orderBy(new Order[]{cb.asc((Expression)changeDate)});
        return this._entityManager.createQuery(cbQuery).getResultList();
    }

    public List<? extends AbstractMetadata> getInternalMetadata(ISODate dateFrom, ISODate dateTo, Set<Integer> groups, @Nonnull Specification<OperationAllowed> operationAllowedSpecification) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(Metadata.class);
        Root metadataRoot = cbQuery.from(Metadata.class);
        Root userRoot = cbQuery.from(User.class);
        Path userOwnerPath = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.owner);
        Path groupOwnerPath = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner);
        Subquery subquery = cbQuery.subquery(Integer.class);
        Root opAllowedRoot = subquery.from(OperationAllowed.class);
        Predicate opAllowedPredicate = operationAllowedSpecification.toPredicate(opAllowedRoot, cbQuery, cb);
        subquery.where((Expression)opAllowedPredicate);
        Path opAllowedMetadataId = opAllowedRoot.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId);
        subquery.select((Expression)opAllowedMetadataId);
        Path userIdPath = userRoot.get(User_.id);
        Predicate ownerPredicate = cb.equal((Expression)userOwnerPath, (Expression)userIdPath);
        Path createDate = metadataRoot.get(Metadata_.dataInfo).get(MetadataDataInfo_.createDate);
        Predicate datePredicate = cb.and((Expression)cb.lessThanOrEqualTo((Expression)createDate, (Comparable)dateTo), (Expression)cb.greaterThanOrEqualTo((Expression)createDate, (Comparable)dateFrom));
        Path template = metadataRoot.get(Metadata_.dataInfo).get(MetadataDataInfo_.type_JPAWorkaround);
        Predicate templatePredicate = cb.equal((Expression)template, (Object)Character.valueOf('n'));
        if (!groups.isEmpty()) {
            Predicate inGroups = groupOwnerPath.in(groups);
            cbQuery.select((Selection)metadataRoot).where((Expression)cb.and((Expression)cb.not((Expression)metadataRoot.get(Metadata_.id).in(new Expression[]{subquery})), (Expression)cb.and((Expression)cb.and(new Predicate[]{ownerPredicate, datePredicate, templatePredicate}), (Expression)inGroups)));
        } else {
            cbQuery.select((Selection)metadataRoot).where((Expression)cb.and((Expression)cb.not((Expression)metadataRoot.get(Metadata_.id).in(new Expression[]{subquery})), (Expression)cb.and(new Predicate[]{cb.and(new Predicate[]{ownerPredicate, datePredicate, templatePredicate})})));
        }
        cbQuery.orderBy(new Order[]{cb.asc((Expression)createDate)});
        return this._entityManager.createQuery(cbQuery).getResultList();
    }
}

