/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.xml.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import org.dlib.xml.XmlCodec;
import org.dlib.xml.XmlDocument;
import org.dlib.xml.XmlElement;
import org.dlib.xml.XmlException;
import org.dlib.xml.reader.XmlTag;

public class XmlSimpleReader {
    private static final int CAPACITY = 131072;
    private static final int BUFFER_LEN = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument read(String string) throws FileNotFoundException, IOException, XmlException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8");
        try {
            XmlDocument xmlDocument = this.read(inputStreamReader);
            return xmlDocument;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    public XmlDocument read(Reader reader) throws IOException, XmlException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(131072);
        char[] cArray = new char[16384];
        while ((n = reader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return this.parse(stringBuffer.toString());
    }

    private XmlDocument parse(String string) throws XmlException {
        Vector vector = this.tokenize(string);
        try {
            XmlElement xmlElement = this.buildTree(vector);
            return new XmlDocument(xmlElement);
        }
        catch (XmlException xmlException) {
            this.printStringOfTokens(vector);
            throw xmlException;
        }
    }

    private Vector tokenize(String string) throws XmlException {
        Vector<Object> vector = new Vector<Object>(131072);
        while (true) {
            String string2;
            int n = string.indexOf("<");
            int n2 = string.indexOf(">");
            if (n == -1 && n2 == -1) {
                vector.addElement(string);
                return vector;
            }
            if (n == -1) {
                throw new XmlException("Found '>' simbol without preceding '<' simbol");
            }
            if (n2 == -1) {
                throw new XmlException("Closing '>' simbol not found");
            }
            if (n > n2) {
                throw new XmlException("Found '>' simbol before relative '<' simbol");
            }
            String string3 = string.substring(n + 1, n2).trim();
            if (n > 0 && !(string2 = string.substring(0, n)).trim().equals("")) {
                vector.addElement(string2);
            }
            string = string.substring(n2 + 1);
            if (string3.startsWith("?xml ") || string3.startsWith("!-- ")) continue;
            vector.addElement(new XmlTag(string3));
        }
    }

    private XmlElement buildTree(Vector vector) throws XmlException {
        boolean bl;
        if (vector.size() != 0) {
            this.applyRule5(vector, 0);
        }
        if (vector.size() > 0) {
            this.applyRule5(vector, vector.size() - 1);
        }
        if (vector.size() == 0) {
            return new XmlElement();
        }
        do {
            bl = false;
            for (int i = vector.size() - 2; i >= 0; --i) {
                while (this.applyRule4(vector, i)) {
                    bl = true;
                }
                if (this.applyRule1(vector, i)) {
                    bl = true;
                }
                if (this.applyRule2(vector, i)) {
                    bl = true;
                }
                if (!this.applyRule3(vector, i)) continue;
                bl = true;
            }
        } while (bl);
        if (vector.size() == 1 && vector.elementAt(0) instanceof XmlElement) {
            return (XmlElement)vector.elementAt(0);
        }
        throw new XmlException("Unable to build document");
    }

    private boolean applyRule1(Vector vector, int n) {
        if (n + 2 > vector.size()) {
            return false;
        }
        if (!(vector.elementAt(n) instanceof XmlTag)) {
            return false;
        }
        if (!(vector.elementAt(n + 1) instanceof String)) {
            return false;
        }
        XmlTag xmlTag = (XmlTag)vector.elementAt(n);
        String string = (String)vector.elementAt(n + 1);
        if (!xmlTag.isStartingTag()) {
            return false;
        }
        xmlTag.setValue(XmlCodec.decode(string));
        vector.removeElementAt(n + 1);
        return true;
    }

    private boolean applyRule2(Vector vector, int n) {
        if (n + 2 > vector.size()) {
            return false;
        }
        if (!(vector.elementAt(n) instanceof XmlTag)) {
            return false;
        }
        if (!(vector.elementAt(n + 1) instanceof XmlTag)) {
            return false;
        }
        XmlTag xmlTag = (XmlTag)vector.elementAt(n);
        XmlTag xmlTag2 = (XmlTag)vector.elementAt(n + 1);
        if (!xmlTag.isStartingTag()) {
            return false;
        }
        if (!xmlTag2.isEndingTag()) {
            return false;
        }
        if (!xmlTag.getName().equals(xmlTag2.getName())) {
            return false;
        }
        XmlElement xmlElement = xmlTag.getXmlElement();
        vector.setElementAt(xmlElement, n);
        vector.removeElementAt(n + 1);
        return true;
    }

    private boolean applyRule3(Vector vector, int n) {
        if (!(vector.elementAt(n) instanceof XmlTag)) {
            return false;
        }
        XmlTag xmlTag = (XmlTag)vector.elementAt(n);
        if (!xmlTag.isFullTag()) {
            return false;
        }
        vector.setElementAt(xmlTag.getXmlElement(), n);
        return true;
    }

    private boolean applyRule4(Vector vector, int n) {
        if (n + 2 > vector.size()) {
            return false;
        }
        if (!(vector.elementAt(n) instanceof XmlTag)) {
            return false;
        }
        if (!(vector.elementAt(n + 1) instanceof XmlElement)) {
            return false;
        }
        XmlTag xmlTag = (XmlTag)vector.elementAt(n);
        XmlElement xmlElement = (XmlElement)vector.elementAt(n + 1);
        if (!xmlTag.isStartingTag()) {
            return false;
        }
        xmlTag.addChild(xmlElement);
        vector.removeElementAt(n + 1);
        return true;
    }

    private boolean applyRule5(Vector vector, int n) throws XmlException {
        if (!(vector.elementAt(n) instanceof String)) {
            return false;
        }
        String string = (String)vector.elementAt(n);
        if (!string.trim().equals("")) {
            throw new XmlException("Bad text before starting (or after ending) tag");
        }
        vector.removeElementAt(n);
        return true;
    }

    private void printStringOfTokens(Vector vector) {
        System.out.println("Tokens\n");
        for (int i = 0; i < vector.size(); ++i) {
            System.out.print("[ " + i + " ] : ");
            Object e = vector.elementAt(i);
            if (e instanceof String) {
                System.out.println("[String]<" + e + ">");
                continue;
            }
            System.out.println("[" + e.getClass().getName() + "]" + e);
        }
    }
}

