/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.auditable;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.fao.geonet.auditable.model.RevisionFieldChange;
import org.fao.geonet.auditable.model.RevisionInfo;
import org.fao.geonet.domain.auditable.AuditableEntity;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.BaseAuditableRepository;
import org.springframework.data.history.Revision;
import org.springframework.data.history.Revisions;
import org.springframework.util.StringUtils;

public abstract class BaseAuditableService<U> {
    protected static final String LINE_SEPARATOR = System.lineSeparator();
    protected BaseAuditableRepository<U> repository;
    protected SettingManager settingManager;

    public abstract String getEntityType();

    public void auditSave(U auditableEntity) {
        if (!this.isAuditableEnabled()) {
            return;
        }
        this.repository.save(auditableEntity);
    }

    public void auditDelete(U auditableEntity) {
        if (!this.isAuditableEnabled()) {
            return;
        }
        this.repository.delete(auditableEntity);
    }

    public String getEntityHistoryAsString(Integer entityIdentifier, ResourceBundle messages) {
        if (!this.isAuditableEnabled()) {
            return "";
        }
        Revisions revisions = this.repository.findRevisions((Object)entityIdentifier);
        return this.retrieveRevisionHistoryAsString(revisions, messages);
    }

    public List<RevisionInfo> getEntityHistory(Integer entityIdentifier) {
        if (!this.isAuditableEnabled()) {
            return new ArrayList<RevisionInfo>();
        }
        Revisions revisions = this.repository.findRevisions((Object)entityIdentifier);
        return this.retrieveRevisionHistory(revisions);
    }

    protected String retrieveRevisionHistoryAsString(Revisions<Integer, U> revisions, ResourceBundle messages) {
        List<RevisionInfo> revisionInfoList = this.retrieveRevisionHistory(revisions);
        ArrayList diffs = new ArrayList();
        revisionInfoList.stream().forEach(revision -> {
            ArrayList<String> revisionChanges = new ArrayList<String>();
            revisionChanges.add(revision.getValue());
            revision.getChanges().forEach(change -> {
                boolean oldValueIsDefined = StringUtils.hasLength((String)change.getOldValue());
                boolean newValueIsDefined = StringUtils.hasLength((String)change.getNewValue());
                if (oldValueIsDefined && newValueIsDefined) {
                    revisionChanges.add(String.format(messages.getString("audit.revision.field.updated"), change.getName(), change.getOldValue(), change.getNewValue()));
                } else if (!oldValueIsDefined && newValueIsDefined) {
                    revisionChanges.add(String.format(messages.getString("audit.revision.field.set"), change.getName(), change.getNewValue()));
                } else if (oldValueIsDefined && !newValueIsDefined) {
                    revisionChanges.add(String.format(messages.getString("audit.revision.field.unset"), change.getName()));
                }
            });
            String revisionInfo = String.format(messages.getString("audit.revision"), revision.getUser(), revision.getDate(), String.join((CharSequence)LINE_SEPARATOR, revisionChanges));
            diffs.add(revisionInfo);
        });
        return String.join((CharSequence)LINE_SEPARATOR, diffs);
    }

    protected List<RevisionInfo> retrieveRevisionHistory(Revisions<Integer, U> revisions) {
        String idFieldName = "id";
        List revisionList = revisions.toList();
        int numRevisions = revisions.toList().size();
        ArrayList<RevisionInfo> revisionInfoList = new ArrayList<RevisionInfo>();
        if (numRevisions > 0) {
            Revision initialRevision = (Revision)revisionList.get(0);
            AuditableEntity initialRevisionEntity = (AuditableEntity)initialRevision.getEntity();
            ObjectMapper objectMapper = new ObjectMapper();
            Map revisionMap = (Map)objectMapper.convertValue(initialRevision.getEntity(), Map.class);
            revisionMap.values().removeAll(Arrays.asList("", null));
            revisionMap.remove(idFieldName);
            RevisionInfo initialRevisionInfo = new RevisionInfo((Integer)initialRevision.getMetadata().getRequiredRevisionNumber(), initialRevisionEntity.getCreatedBy(), initialRevisionEntity.getCreatedDate(), revisionMap.toString());
            revisionInfoList.add(initialRevisionInfo);
            int i = 0;
            while (i + 1 < numRevisions) {
                Revision revision1 = (Revision)revisionList.get(i);
                Revision revision2 = (Revision)revisionList.get(i + 1);
                Map revision1Map = (Map)objectMapper.convertValue(revision1.getEntity(), Map.class);
                revision1Map.remove(idFieldName);
                Map revision2Map = (Map)objectMapper.convertValue(revision2.getEntity(), Map.class);
                revision2Map.remove(idFieldName);
                MapDifference diff = Maps.difference((Map)revision1Map, (Map)revision2Map);
                revision2Map.values().removeAll(Arrays.asList("", null));
                RevisionInfo revisionInfo = new RevisionInfo((Integer)revision2.getMetadata().getRequiredRevisionNumber(), ((AuditableEntity)revision2.getEntity()).getLastModifiedBy(), ((AuditableEntity)revision2.getEntity()).getLastModifiedDate(), revision2Map.toString());
                diff.entriesDiffering().forEach((key, entry) -> {
                    String oldValueAsString = entry.leftValue() != null ? entry.leftValue().toString() : "";
                    String newValueAsString = entry.rightValue() != null ? entry.rightValue().toString() : "";
                    RevisionFieldChange revisionFieldChange = new RevisionFieldChange((String)key, oldValueAsString, newValueAsString);
                    revisionInfo.addChange(revisionFieldChange);
                });
                revisionInfoList.add(revisionInfo);
                ++i;
            }
        }
        Collections.reverse(revisionInfoList);
        return revisionInfoList;
    }

    protected boolean isAuditableEnabled() {
        return this.settingManager.getValueAsBool("system/auditable/enable", false);
    }
}

