/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import ro.isdc.wro.http.support.ContentTypeResolver;
import ro.isdc.wro.util.Base64;

public class DataUriGenerator {
    private static final String DATA_URI_PREFIX = "data:";

    public String generateDataURI(InputStream inputStream, String fileName) throws IOException {
        StringWriter writer = new StringWriter();
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        inputStream.close();
        String mimeType = this.getMimeType(fileName);
        this.generateDataURI(bytes, writer, mimeType);
        return writer.toString();
    }

    private String getMimeType(String fileName) {
        return ContentTypeResolver.get(fileName, StandardCharsets.UTF_8.name()).replaceAll(" ", "");
    }

    public static boolean isDataUri(String url) {
        return url.startsWith(DATA_URI_PREFIX);
    }

    private void generateDataURI(byte[] bytes, Writer out, String mimeType) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(DATA_URI_PREFIX);
        buffer.append(mimeType);
        buffer.append(";base64,");
        buffer.append(Base64.encodeBytes(bytes));
        out.write(buffer.toString());
    }
}

