/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.http.support.HttpHeader;
import ro.isdc.wro.http.support.RedirectedStreamServletResponseWrapper;
import ro.isdc.wro.model.resource.locator.support.DispatcherStreamLocator;
import ro.isdc.wro.util.WroUtil;

public class GzipFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(GzipFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isGzipAllowed(request)) {
            this.doGzipResponse(request, response, chain);
        } else {
            LOG.debug("Gzip not allowed. Proceeding with chain.");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void doGzipResponse(HttpServletRequest req, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug("Applying gzip on resource: {}", (Object)req.getRequestURI());
        response.setHeader(HttpHeader.CONTENT_ENCODING.toString(), "gzip");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream countingStream = new CountingOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(baos)));
        RedirectedStreamServletResponseWrapper wrappedResponse = new RedirectedStreamServletResponseWrapper((OutputStream)countingStream, response);
        chain.doFilter((ServletRequest)req, (ServletResponse)wrappedResponse);
        countingStream.close();
        response.setContentLength(countingStream.getCount());
        if (countingStream.getCount() > 0) {
            IOUtils.write((byte[])baos.toByteArray(), (OutputStream)response.getOutputStream());
        }
    }

    private boolean isGzipAllowed(HttpServletRequest request) {
        return !DispatcherStreamLocator.isIncludedRequest(request) && WroUtil.isGzipSupported(request);
    }

    public void destroy() {
    }
}

