/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils.nio;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.fao.geonet.utils.nio.PathInputSource;
import org.xml.sax.InputSource;

public class NioPathHolder {
    private static final ThreadLocal<Path> ACTUAL_RELATIVE_TO = new InheritableThreadLocal<Path>();
    private static final ThreadLocal<Path> SYS_ID_RELATIVE_TO = new InheritableThreadLocal<Path>();

    public static void setBase(Path base) {
        if (base != null) {
            ACTUAL_RELATIVE_TO.set(base.getParent());
            SYS_ID_RELATIVE_TO.set(new File(".").getAbsoluteFile().toPath().getParent());
        } else {
            ACTUAL_RELATIVE_TO.set(null);
            SYS_ID_RELATIVE_TO.set(null);
        }
    }

    static InputSource resolveEntity(String publicId, String systemId) throws IOException {
        Path resource = NioPathHolder.resolveResource(publicId, systemId);
        if (resource != null) {
            return new PathInputSource(resource);
        }
        return null;
    }

    public static Path resolveResource(String publicId, String systemId) {
        if (ACTUAL_RELATIVE_TO.get() != null) {
            if (systemId.startsWith("file:/") || systemId.startsWith(ACTUAL_RELATIVE_TO.get().toUri().getScheme())) {
                try {
                    Path srcPath = Paths.get(new URI(systemId));
                    Path relativePath = SYS_ID_RELATIVE_TO.get().relativize(srcPath);
                    Path finalPath = ACTUAL_RELATIVE_TO.get().resolve(relativePath.toString());
                    if (Files.isRegularFile(finalPath, new LinkOption[0])) {
                        return finalPath;
                    }
                }
                catch (URISyntaxException srcPath) {}
            } else {
                try {
                    Path srcPath = ACTUAL_RELATIVE_TO.get().resolve(systemId);
                    if (Files.isRegularFile(srcPath, new LinkOption[0])) {
                        return srcPath;
                    }
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

