/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.fao.geonet.Constants;

public class EMail {
    private static final int DEFAULT_PORT = 25;
    private String sFrom;
    private String sTo;
    private String sSubject;
    private String sBody;
    private String sMailServer;
    private int iPort;
    private String sLastError;
    private BufferedReader in;
    private OutputStreamWriter out;

    public EMail(String mailServer) {
        this.setMailServer(mailServer, 25);
    }

    public EMail(String mailServer, int port) {
        this.setMailServer(mailServer, port);
    }

    public void setMailServer(String mailServer, int port) {
        this.sMailServer = mailServer;
        this.iPort = port;
    }

    public void setFrom(String from) {
        this.sFrom = from;
    }

    public void setTo(String to) {
        this.sTo = to;
    }

    public void setSubject(String subject) {
        this.sSubject = subject;
    }

    public void setBody(String body) {
        this.sBody = body;
    }

    public boolean send() throws IOException {
        Socket socket = new Socket(this.sMailServer, this.iPort);
        try {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new DataInputStream(socket.getInputStream()), Charset.forName(Constants.ENCODING)));
            this.out = new OutputStreamWriter((OutputStream)new DataOutputStream(socket.getOutputStream()), "ISO-8859-1");
            if (this.lookMailServer() && this.sendData("2", "HELO " + InetAddress.getLocalHost().getHostName() + "\r\n") && this.sendData("2", "MAIL FROM: <" + this.sFrom + ">\r\n") && this.sendData("2", "RCPT TO: <" + this.sTo + ">\r\n") && this.sendData("354", "DATA\r\n") && this.sendData("2", this.buildContent()) && this.sendData("2", "QUIT\r\n")) {
                boolean bl = true;
                return bl;
            }
            this.sendData("2", "QUIT\r\n");
        }
        finally {
            IOUtils.closeQuietly((Socket)socket);
        }
        return false;
    }

    public String getLastError() {
        return this.sLastError;
    }

    private boolean lookMailServer() throws IOException {
        this.sLastError = this.in.readLine();
        if (this.sLastError != null) {
            return this.sLastError.startsWith("2");
        }
        return false;
    }

    private boolean sendData(String error, String data) throws IOException {
        this.out.write(data);
        this.out.flush();
        this.sLastError = this.in.readLine();
        if (this.sLastError != null) {
            return this.sLastError.startsWith(error);
        }
        return false;
    }

    private String buildContent() {
        return "Date: " + new Date().toString() + "\r\nFrom: " + this.sFrom + "\r\nSubject: " + this.sSubject + "\r\nTo: " + this.sTo + "\r\n\r\n" + this.sBody + "\r\n\r\n.\r\n";
    }
}

