/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import co.elastic.clients.elasticsearch._helpers.bulk.BulkIngester;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkListener;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.util.BinaryData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.jcs.access.exception.InvalidArgumentException;
import org.fao.geonet.harvester.wfsfeatures.model.WFSHarvesterParameter;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSFeatureUtils;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSHarvesterExchangeState;
import org.fao.geonet.index.es.EsRestClient;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Position;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.referencing.CRS;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class EsWFSFeatureIndexer {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_START_REGEX = "<!\\[CDATA\\[";
    public static final String CDATA_END = "]]>";
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvest.wfs.features");
    @Value(value="${es.index.features}")
    private String index = "features";
    @Value(value="${es.index.features.type}")
    private String indexType = "features";
    @Value(value="${es.index.features.featureCommitInterval:300}")
    private int featureCommitInterval;
    @Value(value="${es.index.features.applyPrecisionModel:false}")
    private boolean applyPrecisionModel;
    @Value(value="${es.index.features.numberOfDecimals:7}")
    private int numberOfDecimals;
    @Autowired
    private EsRestClient client;
    private ObjectMapper jacksonMapper = new ObjectMapper();
    private int nbOfFeatures;
    private static final String DEFAULT_FIELDSUFFIX = "_s";
    private static final String TREE_FIELD_SUFFIX = "_tree";
    private static final String FEATURE_FIELD_PREFIX = "ft_";
    private static final Map<String, String> XSDTYPES_TO_FIELD_NAME_SUFFIX;
    private Map<String, String> featureAttributeToDocumentFieldNames = new LinkedHashMap<String, String>();

    public int getFeatureCommitInterval() {
        return this.featureCommitInterval;
    }

    public void setFeatureCommitInterval(int featureCommitInterval) {
        this.featureCommitInterval = featureCommitInterval;
    }

    public boolean isApplyPrecisionModel() {
        return this.applyPrecisionModel;
    }

    public void setApplyPrecisionModel(boolean applyPrecisionModel) {
        this.applyPrecisionModel = applyPrecisionModel;
    }

    public int getNumberOfDecimals() {
        return this.numberOfDecimals;
    }

    public void setNumberOfDecimals(int numberOfDecimals) {
        this.numberOfDecimals = numberOfDecimals;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public void initialize(Exchange exchange, boolean connect) throws InvalidArgumentException {
        WFSHarvesterParameter configuration = (WFSHarvesterParameter)exchange.getProperty("configuration");
        if (configuration == null) {
            throw new InvalidArgumentException("Missing WFS harvester configuration.");
        }
        try {
            ((EsSearchManager)((SpringCamelContext)exchange.getContext()).getApplicationContext().getBean(EsSearchManager.class)).init(false, Optional.of(Arrays.asList("features")));
        }
        catch (Exception e) {
            LOGGER.error("Failed to create missing index for features. " + e.getMessage());
        }
        LOGGER.info("Initializing harvester configuration for uuid '{}', url '{}',feature type '{}'. treefields are {}, tokenizedFields are {} Exchange id is '{}'.", new Object[]{configuration.getMetadataUuid(), configuration.getUrl(), configuration.getTypeName(), configuration.getTreeFields(), configuration.getTokenizedFields(), exchange.getExchangeId()});
        WFSHarvesterExchangeState config = new WFSHarvesterExchangeState(configuration);
        if (connect) {
            try {
                config.initDataStore();
            }
            catch (Exception e) {
                String errorMsg = String.format("Failed to connect to server '%s'. Error is %s", configuration.getUrl(), e.getMessage());
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
        }
        exchange.setProperty("featureTypeConfig", (Object)config);
    }

    public void deleteFeatures(Exchange exchange) {
        WFSHarvesterExchangeState state = (WFSHarvesterExchangeState)exchange.getProperty("featureTypeConfig");
        String url = state.getParameters().getUrl();
        String typeName = state.getParameters().getTypeName();
        this.deleteFeatures(url, typeName, this.client);
    }

    public void deleteFeatures(String url, String typeName, EsRestClient client) {
        LOGGER.info("Deleting features previously index from service '{}' and feature type '{}' in index '{}/{}'", new Object[]{url, typeName, this.index, this.indexType});
        try {
            long begin = System.currentTimeMillis();
            client.deleteByQuery(this.index, String.format("+featureTypeId:\"%s\"", this.getIdentifier(url, typeName)));
            LOGGER.info("  Features deleted in {} ms.", (Object)(System.currentTimeMillis() - begin));
            begin = System.currentTimeMillis();
            client.deleteByQuery(this.index, String.format("+id:\"%s\"", this.getIdentifier(url, typeName)));
            LOGGER.info("  Report deleted in {} ms.", (Object)(System.currentTimeMillis() - begin));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error connecting to ES at '{}'. Error is {}.", (Object)this.index, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> indexFeatures(Exchange exchange) throws Exception {
        WFSHarvesterExchangeState state = (WFSHarvesterExchangeState)exchange.getProperty("featureTypeConfig");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        String url = state.getParameters().getUrl();
        String typeName = state.getParameters().getTypeName();
        List<String> resolvedTypeNames = state.getResolvedTypeNames();
        String strategyId = state.getStrategyId();
        Map<String, String> tokenizedFields = state.getParameters().getTokenizedFields();
        WFSDataStore wfs = state.getWfsDatastore();
        Map<String, String> featureAttributes = state.getFields();
        TitleResolver titleResolver = this.getTitleResolver(state);
        LOGGER.info("Indexing WFS features from service '{}' and feature type '{}'. Precision model applied: '{}', number of decimals: '{}'", new Object[]{url, typeName, this.applyPrecisionModel, this.numberOfDecimals});
        Report report = new Report(url, typeName);
        ObjectNode protoNode = this.createProtoNode(url, typeName);
        if (state.getParameters().getMetadataUuid() != null) {
            report.put("parent", state.getParameters().getMetadataUuid());
            protoNode.put("recordGroup", state.getParameters().getMetadataUuid());
            ObjectNode linkToParent = this.jacksonMapper.createObjectNode();
            linkToParent.put("name", "feature");
            linkToParent.put("parent", state.getParameters().getMetadataUuid());
            protoNode.set("featureOfRecord", (JsonNode)linkToParent);
        }
        this.initFeatureAttributeToDocumentFieldNamesMapping(featureAttributes, state.getParameters().getTreeFields(), report);
        boolean initializeESReportSucceeded = report.saveHarvesterReport();
        if (!initializeESReportSucceeded) {
            String msg = "Couldn't initialize harvesting report, don't even try to go further querying wfs.";
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        AsyncBulkResutHandler brh = new AsyncBulkResutHandler(typeName, url, this.nbOfFeatures, report, state.getParameters().getMetadataUuid());
        try {
            this.nbOfFeatures = 0;
            long begin = System.currentTimeMillis();
            String epsg = "urn:ogc:def:crs:OGC:1.3:CRS84";
            block14: for (String featureType : resolvedTypeNames) {
                ContentFeatureCollection fc = wfs.getFeatureSource(featureType).getFeatures();
                ReprojectingFeatureCollection rfc = new ReprojectingFeatureCollection((SimpleFeatureCollection)fc, CRS.decode((String)epsg));
                SimpleFeatureIterator features = rfc.features();
                block15: while (true) {
                    while (features.hasNext()) {
                        String featurePointer = String.format("%s#%s", featureType, this.nbOfFeatures);
                        try {
                            SimpleFeature feature = null;
                            try {
                                feature = (SimpleFeature)features.next();
                                featurePointer = String.format("%s/id:%s", featurePointer, feature.getID());
                            }
                            catch (Exception e) {
                                String msg;
                                if (e.getCause() instanceof IOException || e.getCause() instanceof DataSourceException) {
                                    msg = String.format("Error while getting feature %s. Exception is: %s. Harvesting task will be stopped. This is probably a problem with the data source or some network related issues. Try to relaunch it later.", featurePointer, e.getMessage());
                                    LOGGER.warn(msg);
                                    report.put("error_ss", msg);
                                    continue block14;
                                }
                                msg = String.format("Error on reading %s. Exception is: %s", featurePointer, e.getMessage());
                                LOGGER.warn(msg);
                                report.put("error_ss", msg);
                                continue;
                            }
                            ObjectNode rootNode = protoNode.deepCopy();
                            titleResolver.setTitle(rootNode, feature);
                            rootNode.put("featureType", featureType);
                            for (String attributeName : featureAttributes.keySet()) {
                                String msg;
                                Object attributeValue = feature.getAttribute(attributeName);
                                if (attributeValue == null) continue;
                                if (tokenizedFields != null && tokenizedFields.get(attributeName) != null) {
                                    String rawValue = (String)attributeValue;
                                    String value = rawValue.startsWith(CDATA_START) ? rawValue.replaceFirst(CDATA_START_REGEX, "").substring(0, rawValue.length() - CDATA_END.length() - CDATA_START.length()) : rawValue;
                                    String separator = tokenizedFields.get(attributeName);
                                    String[] tokens = value.split(separator);
                                    ArrayNode arrayNode = this.jacksonMapper.createArrayNode();
                                    for (String token : tokens) {
                                        arrayNode.add(token.trim());
                                    }
                                    rootNode.putPOJO(this.getDocumentFieldName(attributeName), (Object)arrayNode);
                                    continue;
                                }
                                if (this.getDocumentFieldName(attributeName).equals("geom")) {
                                    Geometry geom = (Geometry)feature.getDefaultGeometry();
                                    if (this.applyPrecisionModel) {
                                        if (geom.isValid()) {
                                            PrecisionModel precisionModel = new PrecisionModel(Math.pow(10.0, this.numberOfDecimals - 1));
                                            geom = GeometryPrecisionReducer.reduce((Geometry)geom, (PrecisionModel)precisionModel);
                                        } else {
                                            msg = String.format("Feature %s: Cannot apply precision reducer on invalid geometry. Check the geometry validity. The feature will be indexed but with no geometry.", featurePointer);
                                            LOGGER.warn(msg);
                                            report.put("error_ss", msg);
                                            continue;
                                        }
                                    }
                                    String gjson = new GeometryJSON(this.numberOfDecimals).toString(geom);
                                    JsonNode jsonNode = this.jacksonMapper.readTree(gjson.getBytes(StandardCharsets.UTF_8));
                                    rootNode.set(this.getDocumentFieldName(attributeName), jsonNode);
                                    boolean isPoint = geom instanceof Point;
                                    if (isPoint) {
                                        Coordinate point = geom.getCoordinate();
                                        rootNode.put("location", String.format("%s,%s", point.y, point.x));
                                    } else {
                                        report.setPointOnlyForGeomsFalse();
                                    }
                                    BoundingBox bbox = feature.getBounds();
                                    rootNode.put("bbox_xmin", bbox.getMinX());
                                    rootNode.put("bbox_ymin", bbox.getMinY());
                                    rootNode.put("bbox_xmax", bbox.getMaxX());
                                    rootNode.put("bbox_ymax", bbox.getMaxY());
                                    continue;
                                }
                                if (attributeValue instanceof Instant) {
                                    try {
                                        Position position = ((DefaultInstant)attributeValue).getPosition();
                                        if (position == null || position.getDate() == null) continue;
                                        rootNode.put(this.getDocumentFieldName(attributeName), position.getDate().toInstant().toString());
                                    }
                                    catch (Exception instantException) {
                                        msg = String.format("Feature %s: Cannot read attribute %s, value %s. Exception is: %s", featurePointer, attributeName, attributeValue, instantException.getMessage());
                                        LOGGER.warn(msg);
                                        report.put("error_ss", msg);
                                    }
                                    continue;
                                }
                                String value = attributeValue.toString();
                                rootNode.put(this.getDocumentFieldName(attributeName), value.startsWith(CDATA_START) ? value.replaceFirst(CDATA_START_REGEX, "").substring(0, value.length() - CDATA_END.length() - CDATA_START.length()) : value);
                            }
                            ++this.nbOfFeatures;
                            brh.addAction(rootNode, feature);
                            continue block15;
                        }
                        catch (Exception ex) {
                            String msg = String.format("Feature %s: Error is: %s", featurePointer, ex.getMessage());
                            LOGGER.warn(msg);
                            report.put("error_ss", msg);
                        }
                    }
                    continue block14;
                    {
                        continue block15;
                        break;
                    }
                    break;
                }
                finally {
                    features.close();
                }
            }
            LOGGER.info("{}: {} features processed in {} ms.", new Object[]{typeName, this.nbOfFeatures, System.currentTimeMillis() - begin});
            report.success(this.nbOfFeatures);
        }
        catch (Exception e) {
            report.put("status_s", "error");
            report.put("error_ss", e.getMessage());
            LOGGER.error(e.getMessage());
            throw e;
        }
        finally {
            brh.close();
            report.saveHarvesterReport();
            future.complete(null);
        }
        return future;
    }

    private TitleResolver getTitleResolver(final WFSHarvesterExchangeState state) {
        String defaultTitleAttribute;
        final String titleExpression = state.getParameters().getTitleExpression();
        String string = defaultTitleAttribute = titleExpression == null ? WFSFeatureUtils.guessFeatureTitleAttribute(state.getFields()) : null;
        TitleResolver titleResolver = titleExpression != null ? new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
                objectNode.put("resourceTitle", WFSFeatureUtils.buildFeatureTitle(simpleFeature, state.getFields(), titleExpression));
            }
        } : (defaultTitleAttribute != null ? new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
                Object titleAttribute = simpleFeature.getAttribute(defaultTitleAttribute);
                if (titleAttribute != null) {
                    objectNode.put("resourceTitle", titleAttribute.toString());
                }
            }
        } : new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
            }
        });
        return titleResolver;
    }

    private ObjectNode createProtoNode(String url, String typeName) {
        ObjectNode protoNode = this.jacksonMapper.createObjectNode();
        protoNode.put("docType", "feature");
        protoNode.put("resourceType", "feature");
        protoNode.put("featureTypeId", this.getIdentifier(url, typeName));
        return protoNode;
    }

    private String getIdentifier(String url, String typeName) {
        try {
            return URLEncoder.encode(url + "#" + typeName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("  Can not build an URL encoded identifier from {}#{}. Exception is {}.", new Object[]{url, typeName, e.getMessage()});
            return null;
        }
    }

    private void initFeatureAttributeToDocumentFieldNamesMapping(Map<String, String> featureAttributes, List<String> treeFields, Report report) {
        for (String attributeName : featureAttributes.keySet()) {
            String attributeType = featureAttributes.get(attributeName);
            if (attributeType.equals("geometry")) {
                this.featureAttributeToDocumentFieldNames.put(attributeName, "geom");
                continue;
            }
            boolean isTree = treeFields != null && treeFields.contains(attributeName);
            this.featureAttributeToDocumentFieldNames.put(attributeName, String.join((CharSequence)"", FEATURE_FIELD_PREFIX, attributeName, XSDTYPES_TO_FIELD_NAME_SUFFIX.get(attributeType), isTree ? TREE_FIELD_SUFFIX : ""));
        }
        report.put("ftColumns_s", Joiner.on((String)"|").join(featureAttributes.keySet()));
        report.put("docColumns_s", Joiner.on((String)"|").join(this.featureAttributeToDocumentFieldNames.values()));
    }

    private String getDocumentFieldName(String attributeName) {
        return this.featureAttributeToDocumentFieldNames.get(attributeName);
    }

    static {
        try {
            Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        XSDTYPES_TO_FIELD_NAME_SUFFIX = ImmutableMap.builder().put((Object)"integer", (Object)"_ti").put((Object)"string", (Object)DEFAULT_FIELDSUFFIX).put((Object)"double", (Object)"_d").put((Object)"boolean", (Object)"_b").put((Object)"date", (Object)"_dt").put((Object)"dateTime", (Object)"_dt").build();
    }

    class AsyncBulkResutHandler
    extends BulkResutHandler {
        public AsyncBulkResutHandler(String typeName, String url, int firstFeatureIndex, Report report, String metadataUuid) {
            super(typeName, url, firstFeatureIndex, report, metadataUuid);
        }
    }

    abstract class BulkResutHandler {
        protected String typeName;
        private String url;
        protected int firstFeatureIndex;
        private Report report;
        private String metadataUuid;
        protected long begin;
        protected BulkIngester<String> bulk;
        protected int bulkSize;
        protected int failuresCount;
        BulkListener<String> listener;

        public BulkResutHandler(final String typeName, String url, final int firstFeatureIndex, final Report report, String metadataUuid) {
            this.typeName = typeName;
            this.url = url;
            this.firstFeatureIndex = firstFeatureIndex;
            this.report = report;
            this.metadataUuid = metadataUuid;
            this.bulkSize = 0;
            this.failuresCount = 0;
            LOGGER.debug("  {} - Indexing with bulk ingester (with maxOperations {}) ...", (Object)typeName, (Object)EsWFSFeatureIndexer.this.featureCommitInterval);
            this.listener = new BulkListener<String>(){

                public void beforeBulk(long executionId, BulkRequest request, List<String> contexts) {
                }

                public void afterBulk(long executionId, BulkRequest request, List<String> contexts, BulkResponse bulkResponse) {
                    AtomicInteger bulkFailures = new AtomicInteger();
                    if (bulkResponse.errors()) {
                        bulkResponse.items().forEach(e -> {
                            if (e.status() != 200 && e.status() != 201) {
                                String msg = String.format("Feature %s: Indexing error. Error is: %s", e.id(), e.error().toString());
                                report.put("error_ss", msg);
                                LOGGER.warn(msg);
                                bulkFailures.getAndIncrement();
                            }
                        });
                    }
                    LOGGER.debug("  {} - {} features indexed in {} ms{}.", new Object[]{typeName, firstFeatureIndex + BulkResutHandler.this.bulkSize, System.currentTimeMillis() - BulkResutHandler.this.begin, bulkResponse.errors() ? " but with " + bulkFailures + " errors" : ""});
                    BulkResutHandler.this.failuresCount = bulkFailures.get();
                }

                public void afterBulk(long executionId, BulkRequest request, List<String> contexts, Throwable failure) {
                    String msg = String.format("  %s - %s features indexed in %s ms but with errors. Exception: %s", typeName, firstFeatureIndex + BulkResutHandler.this.bulkSize, System.currentTimeMillis() - BulkResutHandler.this.begin, failure.getMessage());
                    report.put("error_ss", msg);
                    LOGGER.error(msg);
                }
            };
            this.bulk = BulkIngester.of(b -> b.client(EsWFSFeatureIndexer.this.client.getAsynchClient()).listener(this.listener).maxOperations(EsWFSFeatureIndexer.this.featureCommitInterval));
        }

        public int getBulkSize() {
            return this.bulkSize;
        }

        public int getNumberOfIndexedFeatures() {
            return this.bulkSize - this.failuresCount;
        }

        public void addAction(ObjectNode rootNode, SimpleFeature feature) throws JsonProcessingException {
            Object featureId = feature.getID();
            if (((String)featureId).toLowerCase().indexOf("placeholder") > -1) {
                featureId = "fid-" + EsWFSFeatureIndexer.this.nbOfFeatures;
            }
            String id = String.format("%s#%s#%s", this.url, this.typeName, featureId);
            BinaryData data = BinaryData.of((byte[])EsWFSFeatureIndexer.this.jacksonMapper.writeValueAsString((Object)rootNode).getBytes(StandardCharsets.UTF_8), (String)"application/json");
            this.bulk.add(b -> b.index(io -> ((IndexOperation.Builder)((IndexOperation.Builder)io.index(EsWFSFeatureIndexer.this.index)).id(id)).document((Object)data)), (Object)id);
            ++this.bulkSize;
        }

        public void close() {
            if (this.bulk != null) {
                this.bulk.close();
            }
        }
    }

    class Report {
        private Map<String, Object> report = new HashMap<String, Object>();
        private String url;
        private String typeName;
        private boolean pointOnlyForGeoms;

        public Report(String url, String typeName) {
            this.typeName = typeName;
            this.url = url;
            this.pointOnlyForGeoms = true;
            this.report.put("id", EsWFSFeatureIndexer.this.getIdentifier(url, typeName));
            this.report.put("docType", "harvesterReport");
        }

        public void put(String key, Object value) {
            this.report.put(key, value);
        }

        public void setPointOnlyForGeomsFalse() {
            this.pointOnlyForGeoms = false;
        }

        public void success(int nbOfFeatures) {
            this.report.put("status_s", "success");
            this.report.put("totalRecords_i", nbOfFeatures);
            OffsetDateTime dateTime = OffsetDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
            this.report.put("endDate_dt", dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            this.report.put("isPointOnly", this.pointOnlyForGeoms);
        }

        public boolean saveHarvesterReport() {
            IndexRequest request = IndexRequest.of(b -> b.index(EsWFSFeatureIndexer.this.index).id(this.report.get("id").toString()).document(this.report));
            try {
                IndexResponse response = EsWFSFeatureIndexer.this.client.getClient().index(request);
                if (response.result() == Result.Created || response.result() == Result.Updated) {
                    LOGGER.info("Report saved for service {} and typename {}. Report id is {}", new Object[]{this.url, this.typeName, this.report.get("id")});
                } else {
                    LOGGER.info("Failed to save report for {}. Error was '{}'.", (Object)this.typeName, (Object)response.result());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }

    static interface TitleResolver {
        public void setTitle(ObjectNode var1, SimpleFeature var2);
    }
}

