/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.io.IOException;
import org.apache.tika.Tika;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileMimetypeChecker {
    private static final String[] validImagesMimeTypes = new String[]{"image/gif", "image/png", "image/jpeg"};
    private static final String[] validThesaurusMimeTypes = new String[]{"application/xml", "application/rdf+xml"};
    private static final String[] validCsvMimeTypes = new String[]{"text/plain", "text/csv"};

    public void checkValidImageMimeType(MultipartFile file) throws IOException {
        this.checkValidMimeType(file, validImagesMimeTypes);
    }

    public void checkValidThesaurusMimeType(MultipartFile file) throws IOException {
        this.checkValidMimeType(file, validThesaurusMimeTypes);
    }

    public void checkValidCsvMimeType(MultipartFile file) throws IOException {
        this.checkValidMimeType(file, validCsvMimeTypes);
    }

    public void checkValidMimeType(MultipartFile file, String[] validMimeTypes) throws IOException {
        MediaType mediaType;
        if (validMimeTypes == null || validMimeTypes.length == 0) {
            throw new IllegalArgumentException("No allowed MIME types are configured. Please configure them in System Settings. To allow this file type, configure it in System Settings > Allowed file mime types to attach to a metadata record.");
        }
        Tika tika = new Tika();
        String mimeType = tika.detect(file.getInputStream(), file.getOriginalFilename());
        for (String validMimeType : validMimeTypes) {
            if (!validMimeType.equals(mimeType)) continue;
            return;
        }
        try {
            mediaType = MediaType.parseMediaType((String)mimeType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("The uploaded file '%s' has an invalid or unrecognized MIME type ('%s'). Ensure the file is not corrupted and has a valid extension or content type.", file.getOriginalFilename(), mimeType), e);
        }
        for (String validMimeType : validMimeTypes) {
            try {
                MediaType validMediaType = MediaType.parseMediaType((String)validMimeType);
                if (!validMediaType.includes(mediaType)) continue;
                return;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid configured MIME type '%s' in System Settings. Please correct or remove this value from the allowed MIME types list.", validMimeType), e);
            }
        }
        throw new IllegalArgumentException(String.format("File '%s' with type '%s' is not supported. To allow this file type, configure it in System Settings > Allowed file mime types to attach to a metadata record.", file.getOriginalFilename(), mimeType));
    }
}

