/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.resources.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.services.resources.handlers.IResourceUploadHandler;
import org.fao.geonet.services.resources.handlers.ResourceHandlerException;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;

public class DefaultResourceUploadHandler
implements IResourceUploadHandler {
    private static void moveFile(ServiceContext context, int metadataId, String fileName, InputStream is, String access, String overwrite) throws Exception {
        Store store = (Store)context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        String uuid = metadataUtils.getMetadataUuid(Integer.toString(metadataId));
        MetadataResourceVisibility visibility = MetadataResourceVisibility.parse((String)access);
        if (overwrite.equals("no") && store.getResourceDescription(context, uuid, visibility, fileName, Boolean.valueOf(true)) != null) {
            throw new Exception("File upload unsuccessful because " + fileName + " already exists and overwrite was not permitted");
        }
        store.putResource(context, uuid, fileName, is, null, visibility, Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveFile(ServiceContext context, int metadataId, String fileName, Path uploadDir, String access, String overwrite) throws Exception {
        Store store = (Store)context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        String uuid = metadataUtils.getMetadataUuid(Integer.toString(metadataId));
        Path source = uploadDir.resolve(fileName);
        try {
            MetadataResourceVisibility visibility = MetadataResourceVisibility.parse((String)access);
            if (overwrite.equals("no") && store.getResourceDescription(context, uuid, visibility, fileName, Boolean.valueOf(true)) != null) {
                throw new Exception("File upload unsuccessful because " + fileName + " already exists and overwrite was not permitted");
            }
            store.putResource(context, uuid, (Resource)new PathResource(source), visibility);
        }
        finally {
            Files.delete(source);
        }
    }

    @Override
    public void onUpload(ServiceContext context, Element params, int metadataId, String fileName, double fileSize) throws ResourceHandlerException {
        try {
            Path uploadDir = context.getUploadDir();
            String access = Util.getParam((Element)params, (String)"access", (String)"private");
            String overwrite = Util.getParam((Element)params, (String)"overwrite", (String)"no");
            DefaultResourceUploadHandler.moveFile(context, metadataId, fileName, uploadDir, access, overwrite);
            this.storeFileUploadRequest(context, metadataId, fileName, fileSize);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.resources", (String)("DefaultResourceUploadHandler (onUpload): " + ex.getMessage()), (Throwable)ex);
            throw new ResourceHandlerException(ex);
        }
    }

    private void storeFileUploadRequest(ServiceContext context, int metadataId, String fileName, double fileSize) {
        MetadataFileUploadRepository repo = (MetadataFileUploadRepository)context.getBean(MetadataFileUploadRepository.class);
        MetadataFileUpload metadataFileUpload = new MetadataFileUpload();
        metadataFileUpload.setMetadataId(metadataId);
        metadataFileUpload.setFileName(fileName);
        metadataFileUpload.setFileSize(Double.valueOf(fileSize));
        metadataFileUpload.setUploadDate(new ISODate().toString());
        metadataFileUpload.setUserName(context.getUserSession().getUsername());
        repo.save((Object)metadataFileUpload);
    }

    @Override
    public void onUpload(InputStream is, ServiceContext context, String access, String overwrite, int metadataId, String fileName, double fileSize) throws ResourceHandlerException {
        try {
            DefaultResourceUploadHandler.moveFile(context, metadataId, fileName, is, access, overwrite);
            this.storeFileUploadRequest(context, metadataId, fileName, fileSize);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.resources", (String)("DefaultResourceUploadHandler (onUpload): " + ex.getMessage()), (Throwable)ex);
            throw new ResourceHandlerException(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

