/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users.transfer;

import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.users.transfer.OwnerResponse;
import org.fao.geonet.api.users.transfer.TransferRequest;
import org.fao.geonet.api.users.transfer.UserGroupsResponse;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.GroupType;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/users"})
@Tag(name="users", description="User operations")
@Controller(value="usersTransfer")
public class TransferApi {
    @Autowired
    UserRepository userRepository;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    OperationAllowedRepository operationAllowedRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    DataManager dataManager;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    @Qualifier(value="apiMessages")
    ResourceBundleMessageSource messages;

    @Operation(summary="Get owners", description="Return users who actually owns one or more records.")
    @RequestMapping(path={"owners"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseBody
    public List<OwnerResponse> getRecordOwners(@Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        List users = this.userRepository.findAll();
        ArrayList<OwnerResponse> ownerList = new ArrayList<OwnerResponse>();
        for (User u : users) {
            long userRecordsCount = this.metadataRepository.count(MetadataSpecs.hasOwner((int)u.getId()));
            if (userRecordsCount <= 0L) continue;
            ownerList.add(new OwnerResponse(u, userRecordsCount));
        }
        return ownerList;
    }

    @Operation(summary="Retrieve all user groups", description="")
    @RequestMapping(value={"/groups"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public List<UserGroupsResponse> retrieveAllUserGroups(@RequestParam(value="groupTypes", required=false) List<GroupType> groupTypes, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        ArrayList<UserGroupsResponse> list = new ArrayList<UserGroupsResponse>();
        if (myProfile == Profile.Administrator || myProfile == Profile.UserAdmin) {
            List userGroups;
            List allAdmin = this.userRepository.findAllByProfile(Profile.Administrator);
            Group adminGroup = new Group();
            adminGroup.setName("allAdmins");
            for (User u : allAdmin) {
                list.add(new UserGroupsResponse(u, adminGroup, Profile.Administrator.name()));
            }
            if (myProfile == Profile.Administrator) {
                userGroups = this.userGroupRepository.findAll();
            } else {
                List myGroups = this.userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)session.getUserIdAsInt())).stream().map(ug -> ug.getGroup().getId()).collect(Collectors.toList());
                userGroups = this.userGroupRepository.findAll(UserGroupSpecs.hasGroupIds(myGroups));
            }
            if (groupTypes != null) {
                userGroups = userGroups.stream().filter(ug -> groupTypes.contains(ug.getGroup().getType())).collect(Collectors.toList());
            }
            for (UserGroup ug2 : userGroups) {
                list.add(new UserGroupsResponse(ug2.getUser(), ug2.getGroup(), ug2.getProfile().name()));
            }
            return list;
        }
        throw new SecurityException("You don't have rights to do get the groups for this user");
    }

    @Operation(summary="Transfer privileges", description="")
    @RequestMapping(value={"/owners"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseBody
    public ResponseEntity saveOwners(@RequestBody TransferRequest transfer, @Parameter(hidden=true) HttpSession httpSession, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        int groupId = transfer.getTargetGroup();
        if (!ReservedGroup.isReserved((int)groupId)) {
            this.checkGroupIsWorkspace(groupId, locale);
        }
        Set<String> sourcePriv = this.retrievePrivileges(context, transfer.getSourceUser(), transfer.getSourceGroup());
        Set<String> targetPriv = this.retrievePrivileges(context, null, transfer.getTargetGroup());
        this.dataManager.flush();
        int privCount = 0;
        HashSet<Integer> metadata = new HashSet<Integer>();
        if (sourcePriv.size() > 0) {
            for (String string : sourcePriv) {
                StringTokenizer st = new StringTokenizer(string, "|");
                int opId = Integer.parseInt(st.nextToken());
                int mdId = Integer.parseInt(st.nextToken());
                if (transfer.getSourceGroup() != transfer.getTargetGroup()) {
                    this.dataManager.unsetOperation(context, mdId, transfer.getSourceGroup(), opId);
                    if (!targetPriv.contains(string)) {
                        OperationAllowedId id = new OperationAllowedId().setGroupId(transfer.getTargetGroup()).setMetadataId(mdId).setOperationId(opId);
                        OperationAllowed operationAllowed = new OperationAllowed(id);
                        this.operationAllowedRepository.save((Object)operationAllowed);
                    }
                }
                metadata.add(mdId);
                ++privCount;
            }
        }
        List sourceUserRecords = this.metadataRepository.findAllIdsBy(MetadataSpecs.hasOwner((int)transfer.getSourceUser()));
        metadata.addAll(sourceUserRecords);
        for (Integer i : metadata) {
            AbstractMetadata metadata1 = this.metadataRepository.findOne(i.intValue());
            metadata1.getSourceInfo().setGroupOwner(Integer.valueOf(transfer.getTargetGroup())).setOwner(Integer.valueOf(transfer.getTargetUser()));
            this.metadataManager.save(metadata1);
        }
        this.dataManager.flush();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = metadata.iterator();
        while (iterator.hasNext()) {
            int mdId = (Integer)iterator.next();
            arrayList.add(Integer.toString(mdId));
        }
        this.dataManager.indexMetadata(arrayList);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private void checkGroupIsWorkspace(Integer groupId, Locale locale) throws ResourceNotFoundException, IllegalArgumentException {
        Group group = this.groupRepository.findById((Object)groupId).orElse(null);
        if (group == null) {
            throw new ResourceNotFoundException(this.messages.getMessage("api.groups.group_not_found", new Object[]{groupId}, locale));
        }
        if (group.getType() != GroupType.Workspace) {
            throw new IllegalArgumentException(this.messages.getMessage("api.groups.group_not_workspace", new Object[]{groupId}, locale));
        }
    }

    private Set<String> retrievePrivileges(ServiceContext context, Integer userId, int groupId) throws SQLException {
        List opsAllowed = userId == null ? this.operationAllowedRepository.findAllById_GroupId(groupId) : this.operationAllowedRepository.findAllWithOwner(userId.intValue(), Optional.of((Object)OperationAllowedSpecs.hasGroupId((int)groupId)));
        HashSet<String> result = new HashSet<String>();
        for (OperationAllowed elem : opsAllowed) {
            int opId = elem.getId().getOperationId();
            int mdId = elem.getId().getMetadataId();
            result.add(opId + "|" + mdId);
        }
        return result;
    }
}

