/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.reports;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.search.EsSearchManager;

public final class ReportUtils {
    public static final CSVFormat CSV_FORMAT = CSVFormat.DEFAULT.withRecordSeparator("\n").withQuoteMode(QuoteMode.ALL);

    private ReportUtils() {
    }

    public static Set<Integer> groupsForFilter(ServiceContext context, List<Integer> groups) throws Exception {
        HashSet requestedGroups = groups == null ? new HashSet() : ImmutableSet.copyOf(groups);
        Profile userProfile = context.getUserSession().getProfile();
        if (userProfile != null && userProfile.equals((Object)Profile.Administrator)) {
            return requestedGroups;
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        AccessManager am = (AccessManager)gc.getBean(AccessManager.class);
        Set userGroups = am.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
        userGroups.remove(ReservedGroup.guest.getId());
        userGroups.remove(ReservedGroup.all.getId());
        userGroups.remove(ReservedGroup.intranet.getId());
        if (requestedGroups.isEmpty()) {
            return userGroups;
        }
        HashSet<Integer> filterRequestedGroups = new HashSet<Integer>();
        Iterator iterator = requestedGroups.iterator();
        while (iterator.hasNext()) {
            Integer gr = (Integer)iterator.next();
            if (!userGroups.contains(gr)) continue;
            filterRequestedGroups.add(gr);
        }
        if (!filterRequestedGroups.isEmpty()) {
            return filterRequestedGroups;
        }
        return userGroups;
    }

    public static String retrieveMetadataIndex(String metadataUuid, String fieldName, String fieldNameKey) {
        return ReportUtils.retrieveMetadataIndexField(metadataUuid, fieldName, fieldNameKey);
    }

    private static String retrieveMetadataIndexField(String metadataUuid, String fieldName, String fieldNameKey) {
        EsSearchManager searchManager = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
        try {
            Map mdIndexFields = searchManager.getDocument(metadataUuid);
            Object field = mdIndexFields.get(fieldName);
            if (field instanceof HashMap) {
                if (StringUtils.isNotEmpty((String)fieldNameKey)) {
                    return (String)((HashMap)field).get(fieldNameKey);
                }
                return field.toString();
            }
            if (field instanceof String) {
                return (String)field;
            }
            if (field instanceof ArrayList) {
                Object fieldItem = ((ArrayList)field).get(0);
                if (fieldItem instanceof HashMap) {
                    if (StringUtils.isNotEmpty((String)fieldNameKey)) {
                        return (String)((HashMap)fieldItem).get(fieldNameKey);
                    }
                    return fieldItem.toString();
                }
                if (fieldItem instanceof String) {
                    return (String)fieldItem;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

