/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.reports;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.context.ServiceContext;
import org.apache.commons.csv.CSVPrinter;
import org.fao.geonet.api.reports.IReport;
import org.fao.geonet.api.reports.ReportFilter;
import org.fao.geonet.api.reports.ReportUtils;
import org.fao.geonet.auditable.UserAuditableService;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.User_;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

public class ReportUsers
implements IReport {
    private final ReportFilter reportFilter;

    public ReportUsers(ReportFilter filter) {
        this.reportFilter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(ServiceContext context, PrintWriter writer) throws Exception {
        SettingManager settingManager = (SettingManager)context.getBean(SettingManager.class);
        UserAuditableService userAuditableService = (UserAuditableService)context.getBean(UserAuditableService.class);
        boolean isUserHistoryEnabled = settingManager.getValueAsBool("system/auditable/enable", false);
        String lang = context.getLanguage();
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(lang));
        try (CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)writer, ReportUtils.CSV_FORMAT);){
            UserRepository userRepository = (UserRepository)context.getBean(UserRepository.class);
            Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{User_.lastLoginDate})});
            List records = userRepository.findAll(UserSpecs.loginDateBetweenAndByGroups((ISODate)this.reportFilter.getBeginDate(), (ISODate)this.reportFilter.getEndDate(), this.reportFilter.getGroups()), sort);
            csvFilePrinter.printRecord(new Object[]{"Users"});
            csvFilePrinter.println();
            String[] entries = ("Username#Surname#Name#Email#User groups/Profile#Last login date" + (isUserHistoryEnabled ? "#Change history" : "")).split("#");
            csvFilePrinter.printRecord(Arrays.asList(entries));
            for (User user : records) {
                String userChanges;
                String username = user.getUsername();
                String name = Optional.ofNullable(user.getName()).orElse("");
                String surname = Optional.ofNullable(user.getSurname()).orElse("");
                String email = Optional.ofNullable(user.getEmail()).orElse("");
                String lastLoginDate = user.getLastLoginDate();
                String userGroupsInfo = this.retrieveGroupsListInfo(context, user);
                if (!StringUtils.hasLength((String)userGroupsInfo)) {
                    userGroupsInfo = user.getProfile().name();
                }
                ArrayList<String> metadataRecord = new ArrayList<String>(isUserHistoryEnabled ? 7 : 6);
                metadataRecord.add(username);
                metadataRecord.add(surname);
                metadataRecord.add(name);
                metadataRecord.add(email);
                metadataRecord.add(userGroupsInfo);
                metadataRecord.add(lastLoginDate);
                if (isUserHistoryEnabled && StringUtils.hasLength((String)(userChanges = userAuditableService.getEntityHistoryAsString(Integer.valueOf(user.getId()), messages)))) {
                    metadataRecord.add(userChanges);
                }
                csvFilePrinter.printRecord(metadataRecord);
            }
        }
        finally {
            writer.flush();
        }
    }

    private String retrieveGroupsListInfo(ServiceContext context, User user) {
        StringBuilder userGroupsList = new StringBuilder();
        UserGroupRepository userGroupRepository = (UserGroupRepository)context.getBean(UserGroupRepository.class);
        List userGroups = userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)user.getId()));
        int i = 0;
        for (UserGroup ug : userGroups) {
            Group g = ug.getGroup();
            String groupName = (String)g.getLabelTranslations().get(context.getLanguage());
            if (groupName == null) {
                groupName = g.getName();
            }
            String groupProfile = ug.getId().getProfile().name();
            if (i++ > 0) {
                userGroupsList.append("-");
            }
            userGroupsList.append(groupName).append("/").append(groupProfile);
        }
        return userGroupsList.toString();
    }
}

