/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import io.swagger.v3.oas.annotations.Operation;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.servlet.http.HttpServletResponse;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.formatters.AbstractFormatService;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.FilePathChecker;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="md.formatter.resource")
public class Resource
extends AbstractFormatService {
    @RequestMapping(value={"/{portal}/{lang}/md.formatter.resource"})
    @Operation(hidden=true)
    public void exec(@RequestParam(value="id") String xslid, @RequestParam(value="fname") String fileName, @RequestParam(value="schema", required=false) String schema, HttpServletResponse response) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        Path schemaDir = null;
        if (schema != null) {
            schemaDir = ((SchemaManager)applicationContext.getBean(SchemaManager.class)).getSchemaDir(schema);
        }
        try {
            FilePathChecker.verify((String)fileName);
        }
        catch (BadParameterEx ex) {
            response.sendError(403, fileName + " does not identify a file in the " + xslid + " format bundle");
            return;
        }
        Path formatDir = this.getAndVerifyFormatDir((GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class), "id", xslid, schemaDir);
        Path desiredFile = formatDir.resolve(fileName);
        if (!Files.isRegularFile(desiredFile, new LinkOption[0])) {
            response.sendError(404, fileName + " does not identify a file in formatter bundle: " + xslid);
            return;
        }
        if (!Resource.containsFile(formatDir, desiredFile)) {
            response.sendError(403, fileName + " does not identify a file in the " + xslid + " format bundle");
            return;
        }
        response.setStatus(200);
        this.setContentType(response, com.google.common.io.Files.getFileExtension((String)desiredFile.getFileName().toString()));
        Files.copy(desiredFile, (OutputStream)response.getOutputStream());
    }

    private void setContentType(HttpServletResponse response, String fileExtension) {
        switch (fileExtension) {
            case "css": {
                response.setContentType("text/css");
                return;
            }
            case "bmp": {
                response.setContentType("image/bmp");
                return;
            }
            case "gif": {
                response.setContentType("image/gif");
                return;
            }
            case "html": {
                response.setContentType("text/html");
                return;
            }
            case "jpeg": 
            case "jpg": {
                response.setContentType("image/jpeg");
                return;
            }
            case "js": {
                response.setContentType("application/javascript");
                return;
            }
            case "json": {
                response.setContentType("application/json");
                return;
            }
            case "png": {
                response.setContentType("image/png");
                return;
            }
            case "tif": {
                response.setContentType("image/tiff");
                return;
            }
            case "xml": {
                response.setContentType("application/xml");
                return;
            }
            case "xsl": 
            case "xslt": {
                response.setContentType("application/xslt+xml");
                return;
            }
        }
        response.setContentType("application/octet-stream");
    }
}

