/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.processing.report.MetadataReplacementProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class DatabaseProcessUtils {
    public static Element process(ServiceContext context, String id, boolean useRegexp, String search, String replace, String flags, boolean save, boolean index, boolean updateDateStamp, MetadataReplacementProcessingReport report) throws Exception {
        AccessManager accessMan = (AccessManager)context.getBean(AccessManager.class);
        DataManager dataMan = (DataManager)context.getBean(DataManager.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        report.incrementProcessedRecords();
        if (id == null) {
            report.incrementNullRecords();
            return null;
        }
        int iId = Integer.valueOf(id);
        AbstractMetadata info = metadataUtils.findOne(id);
        if (info == null) {
            report.addNotFoundMetadataId(iId);
        } else if (!accessMan.canEdit(context, id)) {
            report.addNotEditableMetadataId(iId);
        } else {
            Element wellFormedXml = null;
            try {
                Lib.resource.checkEditPrivilege(context, id);
                String updatedXml = useRegexp ? (StringUtils.isNotEmpty((String)flags) ? metadataUtils.selectOneWithRegexSearchAndReplaceWithFlags(info.getUuid(), search, replace, flags) : metadataUtils.selectOneWithRegexSearchAndReplace(info.getUuid(), search, replace)) : metadataUtils.selectOneWithSearchAndReplace(info.getUuid(), search, replace);
                wellFormedXml = Xml.loadString((String)updatedXml, (boolean)false);
                String beforeProcessXML = info.getData();
                if (beforeProcessXML.equals(updatedXml)) {
                    report.incrementUnchangedRecords();
                } else if (save) {
                    boolean validate = false;
                    boolean ufo = true;
                    String language = context.getLanguage();
                    dataMan.updateMetadata(context, id, wellFormedXml, validate, ufo, language, new ISODate().toString(), updateDateStamp, index ? IndexingMode.full : IndexingMode.none);
                    if (index) {
                        dataMan.indexMetadata(id, true);
                    }
                }
                report.addMetadataId(iId);
            }
            catch (Exception e) {
                report.addMetadataError(info, e);
                context.error("  Processing failed with error " + e.getMessage());
                context.error((Throwable)e);
            }
            return wellFormedXml;
        }
        return null;
    }
}

