/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.doiservers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.fao.geonet.api.doiservers.model.AnonymousDoiServer;
import org.fao.geonet.api.doiservers.model.DoiServerDto;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.DoiServer;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.DoiServerRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/doiservers"})
@Tag(name="doiservers", description="DOI servers related operations")
@RestController(value="doiservers")
public class DoiServersApi {
    private static final String API_PARAM_DOISERVER_IDENTIFIER = "DOI server identifier";
    private static final String API_PARAM_DOISERVER_DETAILS = "DOI server details";
    public static final String MSG_DOISERVER_WITH_ID_NOT_FOUND = "DOI server with id '%s' not found.";
    private final DoiServerRepository doiServerRepository;
    private final IMetadataUtils metadataUtils;

    DoiServersApi(DoiServerRepository doiServerRepository, IMetadataUtils metadataUtils) {
        this.doiServerRepository = doiServerRepository;
        this.metadataUtils = metadataUtils;
    }

    @Operation(summary="Get DOI servers")
    @GetMapping(produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of all DOI servers."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    public List<AnonymousDoiServer> getDoiServers() {
        List doiServers = this.doiServerRepository.findAll();
        ArrayList<AnonymousDoiServer> list = new ArrayList<AnonymousDoiServer>(doiServers.size());
        doiServers.stream().forEach(e -> list.add(new AnonymousDoiServer(DoiServerDto.from(e))));
        return list;
    }

    @Operation(summary="Get DOI servers that can be used with a metadata")
    @GetMapping(value={"metadata/{metadataId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of all DOI servers where a metadata can be published."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    public List<AnonymousDoiServer> getDoiServers(@Parameter(description="Metadata UUID", required=true, example="") @PathVariable Integer metadataId) {
        List doiServers = this.doiServerRepository.findAll();
        ArrayList<AnonymousDoiServer> list = new ArrayList<AnonymousDoiServer>(doiServers.size());
        AbstractMetadata metadata = this.metadataUtils.findOne(metadataId.intValue());
        Integer groupOwner = metadata.getSourceInfo().getGroupOwner();
        List<DoiServer> doiServersForMetadata = doiServers.stream().filter(s -> s.getPublicationGroups().stream().anyMatch(g -> g.getId() == groupOwner.intValue())).collect(Collectors.toList());
        if (doiServersForMetadata.isEmpty()) {
            doiServersForMetadata = doiServers.stream().filter(s -> s.getPublicationGroups().isEmpty()).collect(Collectors.toList());
        }
        doiServersForMetadata.forEach(s -> {
            DoiServerDto doiServerDto = DoiServerDto.from(s);
            list.add(new AnonymousDoiServer(doiServerDto));
        });
        Collections.sort(list, Comparator.comparing(DoiServerDto::getName));
        return list;
    }

    @Operation(summary="Get a DOI Server")
    @GetMapping(value={"/{doiServerId}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    public AnonymousDoiServer getDoiServer(@Parameter(description="DOI server identifier", required=true, example="") @PathVariable String doiServerId) throws ResourceNotFoundException {
        Optional doiServerOpt = this.doiServerRepository.findOneById(Integer.parseInt(doiServerId));
        if (doiServerOpt.isEmpty()) {
            throw new ResourceNotFoundException(String.format(MSG_DOISERVER_WITH_ID_NOT_FOUND, doiServerId));
        }
        return new AnonymousDoiServer(DoiServerDto.from((DoiServer)doiServerOpt.get()));
    }

    @Operation(summary="Add a DOI server", description="Return the id of the newly created DOI server.")
    @PutMapping(produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="DOI server created."), @ApiResponse(responseCode="400", description="Bad parameters."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Integer> addDoiServer(@Parameter(description="DOI server details", required=true) @RequestBody DoiServerDto doiServerDto) {
        Optional existingDoiServerOpt = this.doiServerRepository.findOneById(doiServerDto.getId());
        if (existingDoiServerOpt.isPresent()) {
            throw new IllegalArgumentException(String.format("DOI server with id '%d' already exists.", doiServerDto.getId()));
        }
        DoiServer doiServer = doiServerDto.asDoiServer();
        this.doiServerRepository.save((Object)doiServer);
        return new ResponseEntity((Object)doiServer.getId(), HttpStatus.CREATED);
    }

    @Operation(summary="Update a DOI server")
    @PutMapping(value={"/{doiServerId}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="DOI server updated."), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDoiServer(@Parameter(description="DOI server identifier", required=true, example="") @PathVariable Integer doiServerId, @Parameter(description="DOI server details", required=true) @RequestBody DoiServerDto doiServerDto) throws ResourceNotFoundException {
        Optional existingMapserverOpt = this.doiServerRepository.findOneById(doiServerId.intValue());
        if (!existingMapserverOpt.isPresent()) {
            throw new ResourceNotFoundException(String.format(MSG_DOISERVER_WITH_ID_NOT_FOUND, doiServerId));
        }
        DoiServer doiServer = doiServerDto.asDoiServer();
        this.doiServerRepository.update((Serializable)doiServerId, entity -> {
            entity.setName(doiServer.getName());
            entity.setDescription(doiServer.getDescription());
            entity.setUrl(doiServer.getUrl());
            entity.setUsername(doiServer.getUsername());
            entity.setPublicUrl(doiServer.getPublicUrl());
            entity.setLandingPageTemplate(doiServer.getLandingPageTemplate());
            entity.setPattern(doiServer.getPattern());
            entity.setPrefix(doiServer.getPrefix());
            entity.setPublicationGroups(doiServer.getPublicationGroups());
        });
    }

    @Operation(summary="Remove a DOI server")
    @DeleteMapping(value={"/{doiServerId}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="DOI server removed."), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteMapserver(@Parameter(description="DOI server identifier", required=true) @PathVariable Integer doiServerId) throws ResourceNotFoundException {
        Optional existingMapserverOpt = this.doiServerRepository.findOneById(doiServerId.intValue());
        if (!existingMapserverOpt.isPresent()) {
            throw new ResourceNotFoundException(String.format(MSG_DOISERVER_WITH_ID_NOT_FOUND, doiServerId));
        }
        this.doiServerRepository.delete((Object)((DoiServer)existingMapserverOpt.get()));
    }

    @Operation(summary="Update a DOI server authentication")
    @PostMapping(value={"/{doiServerId}/auth"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="DOI server updated."), @ApiResponse(responseCode="404", description="Resource not found."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDoiServerAuth(@Parameter(description="DOI server identifier", required=true, example="") @PathVariable Integer doiServerId, @Parameter(description="Password", required=true) @RequestParam String password) throws ResourceNotFoundException {
        Optional existingMapserverOpt = this.doiServerRepository.findOneById(doiServerId.intValue());
        if (!existingMapserverOpt.isPresent()) {
            throw new ResourceNotFoundException(String.format(MSG_DOISERVER_WITH_ID_NOT_FOUND, doiServerId));
        }
        this.doiServerRepository.update((Serializable)doiServerId, entity -> entity.setPassword(password));
    }
}

