/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geometry.utils;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.GeometryValidator;

public class WellKnownText {
    public static final String EMPTY = "EMPTY";
    public static final String SPACE = " ";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String COMMA = ",";
    public static final String NAN = "NaN";
    private static final String NUMBER = "<NUMBER>";
    private static final String EOF = "END-OF-STREAM";
    private static final String EOL = "END-OF-LINE";

    private WellKnownText() {
    }

    public static String toWKT(Geometry geometry) {
        StringBuilder builder = new StringBuilder();
        WellKnownText.toWKT(geometry, builder);
        return builder.toString();
    }

    private static void toWKT(Geometry geometry, final StringBuilder sb) {
        sb.append(WellKnownText.getWKTName(geometry));
        sb.append(SPACE);
        if (geometry.isEmpty()) {
            sb.append(EMPTY);
        } else {
            geometry.visit(new GeometryVisitor<Void, RuntimeException>(){

                @Override
                public Void visit(Circle circle) {
                    sb.append(WellKnownText.LPAREN);
                    this.visitPoint(circle.getX(), circle.getY(), Double.NaN);
                    sb.append(WellKnownText.SPACE);
                    sb.append(circle.getRadiusMeters());
                    if (circle.hasZ()) {
                        sb.append(WellKnownText.SPACE);
                        sb.append(circle.getZ());
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }

                @Override
                public Void visit(GeometryCollection<?> collection) {
                    if (collection.size() == 0) {
                        sb.append(WellKnownText.EMPTY);
                    } else {
                        sb.append(WellKnownText.LPAREN);
                        WellKnownText.toWKT(collection.get(0), sb);
                        for (int i = 1; i < collection.size(); ++i) {
                            sb.append(WellKnownText.COMMA);
                            WellKnownText.toWKT(collection.get(i), sb);
                        }
                        sb.append(WellKnownText.RPAREN);
                    }
                    return null;
                }

                @Override
                public Void visit(Line line) {
                    sb.append(WellKnownText.LPAREN);
                    this.visitPoint(line.getX(0), line.getY(0), line.getZ(0));
                    for (int i = 1; i < line.length(); ++i) {
                        sb.append(WellKnownText.COMMA);
                        sb.append(WellKnownText.SPACE);
                        this.visitPoint(line.getX(i), line.getY(i), line.getZ(i));
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }

                @Override
                public Void visit(LinearRing ring) {
                    throw new IllegalArgumentException("Linear ring is not supported by WKT");
                }

                @Override
                public Void visit(MultiLine multiLine) {
                    this.visitCollection(multiLine);
                    return null;
                }

                @Override
                public Void visit(MultiPoint multiPoint) {
                    if (multiPoint.isEmpty()) {
                        sb.append(WellKnownText.EMPTY);
                        return null;
                    }
                    sb.append(WellKnownText.LPAREN);
                    this.visitPoint(((Point)multiPoint.get(0)).getX(), ((Point)multiPoint.get(0)).getY(), ((Point)multiPoint.get(0)).getZ());
                    for (int i = 1; i < multiPoint.size(); ++i) {
                        sb.append(WellKnownText.COMMA);
                        sb.append(WellKnownText.SPACE);
                        Point point = (Point)multiPoint.get(i);
                        this.visitPoint(point.getX(), point.getY(), point.getZ());
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }

                @Override
                public Void visit(MultiPolygon multiPolygon) {
                    this.visitCollection(multiPolygon);
                    return null;
                }

                @Override
                public Void visit(Point point) {
                    if (point.isEmpty()) {
                        sb.append(WellKnownText.EMPTY);
                    } else {
                        sb.append(WellKnownText.LPAREN);
                        this.visitPoint(point.getX(), point.getY(), point.getZ());
                        sb.append(WellKnownText.RPAREN);
                    }
                    return null;
                }

                private void visitPoint(double lon, double lat, double alt) {
                    sb.append(lon).append(WellKnownText.SPACE).append(lat);
                    if (!Double.isNaN(alt)) {
                        sb.append(WellKnownText.SPACE).append(alt);
                    }
                }

                private void visitCollection(GeometryCollection<?> collection) {
                    if (collection.size() == 0) {
                        sb.append(WellKnownText.EMPTY);
                    } else {
                        sb.append(WellKnownText.LPAREN);
                        collection.get(0).visit(this);
                        for (int i = 1; i < collection.size(); ++i) {
                            sb.append(WellKnownText.COMMA);
                            collection.get(i).visit(this);
                        }
                        sb.append(WellKnownText.RPAREN);
                    }
                }

                @Override
                public Void visit(Polygon polygon) {
                    sb.append(WellKnownText.LPAREN);
                    this.visit((Line)polygon.getPolygon());
                    int numberOfHoles = polygon.getNumberOfHoles();
                    for (int i = 0; i < numberOfHoles; ++i) {
                        sb.append(", ");
                        this.visit((Line)polygon.getHole(i));
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }

                @Override
                public Void visit(Rectangle rectangle) {
                    sb.append(WellKnownText.LPAREN);
                    sb.append(rectangle.getMinX());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMaxX());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMaxY());
                    sb.append(WellKnownText.COMMA);
                    sb.append(WellKnownText.SPACE);
                    sb.append(rectangle.getMinY());
                    if (rectangle.hasZ()) {
                        sb.append(WellKnownText.COMMA);
                        sb.append(WellKnownText.SPACE);
                        sb.append(rectangle.getMinZ());
                        sb.append(WellKnownText.COMMA);
                        sb.append(WellKnownText.SPACE);
                        sb.append(rectangle.getMaxZ());
                    }
                    sb.append(WellKnownText.RPAREN);
                    return null;
                }
            });
        }
    }

    public static String fromWKB(byte[] wkb, int offset, int length) {
        StringBuilder builder = new StringBuilder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(wkb, offset, length);
        WellKnownText.parseGeometry(byteBuffer, builder);
        assert (byteBuffer.remaining() == 0);
        return builder.toString();
    }

    private static void parseGeometry(ByteBuffer byteBuffer, StringBuilder sb) {
        byteBuffer.order(byteBuffer.get() == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        int type = byteBuffer.getInt();
        switch (type) {
            case 1: {
                WellKnownText.parsePoint(byteBuffer, false, sb);
                break;
            }
            case 1001: {
                WellKnownText.parsePoint(byteBuffer, true, sb);
                break;
            }
            case 2: {
                WellKnownText.parseLine(byteBuffer, false, sb);
                break;
            }
            case 1002: {
                WellKnownText.parseLine(byteBuffer, true, sb);
                break;
            }
            case 3: {
                WellKnownText.parsePolygon(byteBuffer, false, sb);
                break;
            }
            case 1003: {
                WellKnownText.parsePolygon(byteBuffer, true, sb);
                break;
            }
            case 4: {
                WellKnownText.parseMultiPoint(byteBuffer, false, sb);
                break;
            }
            case 1004: {
                WellKnownText.parseMultiPoint(byteBuffer, true, sb);
                break;
            }
            case 5: {
                WellKnownText.parseMultiLine(byteBuffer, false, sb);
                break;
            }
            case 1005: {
                WellKnownText.parseMultiLine(byteBuffer, true, sb);
                break;
            }
            case 6: {
                WellKnownText.parseMultiPolygon(byteBuffer, false, sb);
                break;
            }
            case 1006: {
                WellKnownText.parseMultiPolygon(byteBuffer, true, sb);
                break;
            }
            case 7: 
            case 1007: {
                WellKnownText.parseGeometryCollection(byteBuffer, sb);
                break;
            }
            case 17: {
                WellKnownText.parseCircle(byteBuffer, false, sb);
                break;
            }
            case 1017: {
                WellKnownText.parseCircle(byteBuffer, true, sb);
                break;
            }
            case 18: {
                WellKnownText.parseBBox(byteBuffer, false, sb);
                break;
            }
            case 1018: {
                WellKnownText.parseBBox(byteBuffer, true, sb);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown geometry type: " + type);
            }
        }
    }

    private static void writeCoordinate(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append(byteBuffer.getDouble()).append(SPACE).append(byteBuffer.getDouble());
        if (hasZ) {
            sb.append(SPACE).append(byteBuffer.getDouble());
        }
    }

    private static void parsePoint(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append("POINT").append(SPACE);
        sb.append(LPAREN);
        WellKnownText.writeCoordinate(byteBuffer, hasZ, sb);
        sb.append(RPAREN);
    }

    private static void parseMultiPoint(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append("MULTIPOINT").append(SPACE);
        int numPoints = byteBuffer.getInt();
        if (numPoints == 0) {
            sb.append(EMPTY);
            return;
        }
        sb.append(LPAREN);
        for (int i = 0; i < numPoints; ++i) {
            byteBuffer.order(byteBuffer.get() == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            byteBuffer.getInt();
            WellKnownText.writeCoordinate(byteBuffer, hasZ, sb);
            if (i == numPoints - 1) continue;
            sb.append(COMMA);
            sb.append(SPACE);
        }
        sb.append(RPAREN);
    }

    private static void parseLine(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append("LINESTRING").append(SPACE);
        WellKnownText.parseLineString(byteBuffer, hasZ, sb);
    }

    private static void parseMultiLine(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append("MULTILINESTRING").append(SPACE);
        int numLines = byteBuffer.getInt();
        if (numLines == 0) {
            sb.append(EMPTY);
            return;
        }
        sb.append(LPAREN);
        for (int i = 0; i < numLines; ++i) {
            byteBuffer.order(byteBuffer.get() == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            byteBuffer.getInt();
            WellKnownText.parseLineString(byteBuffer, hasZ, sb);
            if (i == numLines - 1) continue;
            sb.append(COMMA);
        }
        sb.append(RPAREN);
    }

    private static void parsePolygon(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append("POLYGON").append(SPACE);
        WellKnownText.parseRings(byteBuffer, hasZ, sb, byteBuffer.getInt());
    }

    private static void parseRings(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb, int numRings) {
        if (numRings == 0) {
            sb.append(EMPTY);
            return;
        }
        sb.append(LPAREN);
        WellKnownText.parseLineString(byteBuffer, hasZ, sb);
        for (int i = 1; i < numRings; ++i) {
            sb.append(COMMA);
            sb.append(SPACE);
            WellKnownText.parseLineString(byteBuffer, hasZ, sb);
        }
        sb.append(RPAREN);
    }

    private static void parseMultiPolygon(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append("MULTIPOLYGON").append(SPACE);
        int numPolygons = byteBuffer.getInt();
        if (numPolygons == 0) {
            sb.append(EMPTY);
            return;
        }
        sb.append(LPAREN);
        for (int i = 0; i < numPolygons; ++i) {
            byteBuffer.order(byteBuffer.get() == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            byteBuffer.getInt();
            WellKnownText.parseRings(byteBuffer, hasZ, sb, byteBuffer.getInt());
            if (i == numPolygons - 1) continue;
            sb.append(COMMA);
        }
        sb.append(RPAREN);
    }

    private static void parseLineString(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        int length = byteBuffer.getInt();
        if (length == 0) {
            sb.append(EMPTY);
            return;
        }
        sb.append(LPAREN);
        for (int i = 0; i < length; ++i) {
            WellKnownText.writeCoordinate(byteBuffer, hasZ, sb);
            if (i == length - 1) continue;
            sb.append(COMMA);
            sb.append(SPACE);
        }
        sb.append(RPAREN);
    }

    private static void parseGeometryCollection(ByteBuffer byteBuffer, StringBuilder sb) {
        sb.append("GEOMETRYCOLLECTION").append(SPACE);
        int numGeometries = byteBuffer.getInt();
        if (numGeometries == 0) {
            sb.append(EMPTY);
            return;
        }
        sb.append(LPAREN);
        for (int i = 0; i < numGeometries; ++i) {
            WellKnownText.parseGeometry(byteBuffer, sb);
            if (i == numGeometries - 1) continue;
            sb.append(COMMA);
        }
        sb.append(RPAREN);
    }

    private static void parseCircle(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append("CIRCLE").append(SPACE);
        sb.append(LPAREN);
        sb.append(byteBuffer.getDouble()).append(SPACE).append(byteBuffer.getDouble());
        double r = byteBuffer.getDouble();
        if (hasZ) {
            sb.append(SPACE).append(byteBuffer.getDouble()).append(SPACE).append(r);
        } else {
            sb.append(SPACE).append(r);
        }
        sb.append(RPAREN);
    }

    private static void parseBBox(ByteBuffer byteBuffer, boolean hasZ, StringBuilder sb) {
        sb.append("BBOX").append(SPACE);
        sb.append(LPAREN);
        sb.append(byteBuffer.getDouble()).append(COMMA).append(SPACE).append(byteBuffer.getDouble());
        sb.append(COMMA).append(SPACE).append(byteBuffer.getDouble()).append(COMMA).append(SPACE).append(byteBuffer.getDouble());
        if (hasZ) {
            sb.append(COMMA).append(SPACE).append(byteBuffer.getDouble()).append(COMMA).append(SPACE).append(byteBuffer.getDouble());
        }
        sb.append(RPAREN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geometry fromWKT(GeometryValidator validator, boolean coerce, String wkt) throws IOException, ParseException {
        try (StringReader reader = new StringReader(wkt);){
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.resetSyntax();
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(160, 255);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(43, 43);
            tokenizer.wordChars(46, 46);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(9, 9);
            tokenizer.whitespaceChars(13, 13);
            tokenizer.whitespaceChars(10, 10);
            tokenizer.commentChar(35);
            Geometry geometry = WellKnownText.parseGeometry(tokenizer, coerce);
            validator.validate(geometry);
            Geometry geometry2 = geometry;
            return geometry2;
        }
    }

    private static Geometry parseGeometry(StreamTokenizer stream, boolean coerce) throws IOException, ParseException {
        String type;
        switch (type = WellKnownText.nextWord(stream).toLowerCase(Locale.ROOT)) {
            case "point": {
                return WellKnownText.parsePoint(stream);
            }
            case "multipoint": {
                return WellKnownText.parseMultiPoint(stream);
            }
            case "linestring": {
                return WellKnownText.parseLine(stream);
            }
            case "multilinestring": {
                return WellKnownText.parseMultiLine(stream);
            }
            case "polygon": {
                return WellKnownText.parsePolygon(stream, coerce);
            }
            case "multipolygon": {
                return WellKnownText.parseMultiPolygon(stream, coerce);
            }
            case "bbox": {
                return WellKnownText.parseBBox(stream);
            }
            case "geometrycollection": {
                return WellKnownText.parseGeometryCollection(stream, coerce);
            }
            case "circle": {
                return WellKnownText.parseCircle(stream);
            }
        }
        throw new IllegalArgumentException("Unknown geometry type: " + type);
    }

    private static GeometryCollection<Geometry> parseGeometryCollection(StreamTokenizer stream, boolean coerce) throws IOException, ParseException {
        if (WellKnownText.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return GeometryCollection.EMPTY;
        }
        ArrayList<Geometry> shapes = new ArrayList<Geometry>();
        shapes.add(WellKnownText.parseGeometry(stream, coerce));
        while (WellKnownText.nextCloserOrComma(stream).equals(COMMA)) {
            shapes.add(WellKnownText.parseGeometry(stream, coerce));
        }
        return new GeometryCollection<Geometry>(shapes);
    }

    private static Point parsePoint(StreamTokenizer stream) throws IOException, ParseException {
        if (WellKnownText.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Point.EMPTY;
        }
        double lon = WellKnownText.nextNumber(stream);
        double lat = WellKnownText.nextNumber(stream);
        Point pt = WellKnownText.isNumberNext(stream) ? new Point(lon, lat, WellKnownText.nextNumber(stream)) : new Point(lon, lat);
        WellKnownText.nextCloser(stream);
        return pt;
    }

    private static void parseCoordinates(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons, ArrayList<Double> alts) throws IOException, ParseException {
        WellKnownText.parseCoordinate(stream, lats, lons, alts);
        while (WellKnownText.nextCloserOrComma(stream).equals(COMMA)) {
            WellKnownText.parseCoordinate(stream, lats, lons, alts);
        }
    }

    private static void parseCoordinate(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons, ArrayList<Double> alts) throws IOException, ParseException {
        lons.add(WellKnownText.nextNumber(stream));
        lats.add(WellKnownText.nextNumber(stream));
        if (WellKnownText.isNumberNext(stream)) {
            alts.add(WellKnownText.nextNumber(stream));
        }
        if (!alts.isEmpty() && alts.size() != lons.size()) {
            throw new ParseException("coordinate dimensions do not match: " + WellKnownText.tokenString(stream), stream.lineno());
        }
    }

    private static MultiPoint parseMultiPoint(StreamTokenizer stream) throws IOException, ParseException {
        String token = WellKnownText.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return MultiPoint.EMPTY;
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        ArrayList<Double> alts = new ArrayList<Double>();
        ArrayList<Point> points = new ArrayList<Point>();
        WellKnownText.parseCoordinates(stream, lats, lons, alts);
        for (int i = 0; i < lats.size(); ++i) {
            if (alts.isEmpty()) {
                points.add(new Point(lons.get(i), lats.get(i)));
                continue;
            }
            points.add(new Point(lons.get(i), lats.get(i), alts.get(i)));
        }
        return new MultiPoint(Collections.unmodifiableList(points));
    }

    private static Line parseLine(StreamTokenizer stream) throws IOException, ParseException {
        String token = WellKnownText.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return Line.EMPTY;
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        ArrayList<Double> alts = new ArrayList<Double>();
        WellKnownText.parseCoordinates(stream, lats, lons, alts);
        if (alts.isEmpty()) {
            return new Line(WellKnownText.toArray(lons), WellKnownText.toArray(lats));
        }
        return new Line(WellKnownText.toArray(lons), WellKnownText.toArray(lats), WellKnownText.toArray(alts));
    }

    private static MultiLine parseMultiLine(StreamTokenizer stream) throws IOException, ParseException {
        String token = WellKnownText.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return MultiLine.EMPTY;
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(WellKnownText.parseLine(stream));
        while (WellKnownText.nextCloserOrComma(stream).equals(COMMA)) {
            lines.add(WellKnownText.parseLine(stream));
        }
        return new MultiLine(Collections.unmodifiableList(lines));
    }

    private static LinearRing parsePolygonHole(StreamTokenizer stream, boolean coerce) throws IOException, ParseException {
        WellKnownText.nextOpener(stream);
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        ArrayList<Double> alts = new ArrayList<Double>();
        WellKnownText.parseCoordinates(stream, lats, lons, alts);
        WellKnownText.closeLinearRingIfCoerced(lats, lons, alts, coerce);
        if (alts.isEmpty()) {
            return new LinearRing(WellKnownText.toArray(lons), WellKnownText.toArray(lats));
        }
        return new LinearRing(WellKnownText.toArray(lons), WellKnownText.toArray(lats), WellKnownText.toArray(alts));
    }

    private static Polygon parsePolygon(StreamTokenizer stream, boolean coerce) throws IOException, ParseException {
        if (WellKnownText.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Polygon.EMPTY;
        }
        WellKnownText.nextOpener(stream);
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        ArrayList<Double> alts = new ArrayList<Double>();
        WellKnownText.parseCoordinates(stream, lats, lons, alts);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        while (WellKnownText.nextCloserOrComma(stream).equals(COMMA)) {
            holes.add(WellKnownText.parsePolygonHole(stream, coerce));
        }
        WellKnownText.closeLinearRingIfCoerced(lats, lons, alts, coerce);
        LinearRing shell = alts.isEmpty() ? new LinearRing(WellKnownText.toArray(lons), WellKnownText.toArray(lats)) : new LinearRing(WellKnownText.toArray(lons), WellKnownText.toArray(lats), WellKnownText.toArray(alts));
        if (holes.isEmpty()) {
            return new Polygon(shell);
        }
        return new Polygon(shell, Collections.unmodifiableList(holes));
    }

    private static void closeLinearRingIfCoerced(ArrayList<Double> lats, ArrayList<Double> lons, ArrayList<Double> alts, boolean coerce) {
        if (coerce && !lats.isEmpty() && !lons.isEmpty()) {
            int last = lats.size() - 1;
            if (!lats.get(0).equals(lats.get(last)) || !lons.get(0).equals(lons.get(last)) || !alts.isEmpty() && !alts.get(0).equals(alts.get(last))) {
                lons.add(lons.get(0));
                lats.add(lats.get(0));
                if (!alts.isEmpty()) {
                    alts.add(alts.get(0));
                }
            }
        }
    }

    private static MultiPolygon parseMultiPolygon(StreamTokenizer stream, boolean coerce) throws IOException, ParseException {
        String token = WellKnownText.nextEmptyOrOpen(stream);
        if (token.equals(EMPTY)) {
            return MultiPolygon.EMPTY;
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        polygons.add(WellKnownText.parsePolygon(stream, coerce));
        while (WellKnownText.nextCloserOrComma(stream).equals(COMMA)) {
            polygons.add(WellKnownText.parsePolygon(stream, coerce));
        }
        return new MultiPolygon(Collections.unmodifiableList(polygons));
    }

    private static Rectangle parseBBox(StreamTokenizer stream) throws IOException, ParseException {
        if (WellKnownText.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Rectangle.EMPTY;
        }
        double minLon = WellKnownText.nextNumber(stream);
        WellKnownText.nextComma(stream);
        double maxLon = WellKnownText.nextNumber(stream);
        WellKnownText.nextComma(stream);
        double maxLat = WellKnownText.nextNumber(stream);
        WellKnownText.nextComma(stream);
        double minLat = WellKnownText.nextNumber(stream);
        WellKnownText.nextCloser(stream);
        return new Rectangle(minLon, maxLon, maxLat, minLat);
    }

    private static Circle parseCircle(StreamTokenizer stream) throws IOException, ParseException {
        if (WellKnownText.nextEmptyOrOpen(stream).equals(EMPTY)) {
            return Circle.EMPTY;
        }
        double lon = WellKnownText.nextNumber(stream);
        double lat = WellKnownText.nextNumber(stream);
        double radius = WellKnownText.nextNumber(stream);
        double alt = Double.NaN;
        if (WellKnownText.isNumberNext(stream)) {
            alt = WellKnownText.nextNumber(stream);
        }
        Circle circle = new Circle(lon, lat, alt, radius);
        WellKnownText.nextCloser(stream);
        return circle;
    }

    private static String nextWord(StreamTokenizer stream) throws ParseException, IOException {
        switch (stream.nextToken()) {
            case -3: {
                String word = stream.sval;
                return word.equalsIgnoreCase(EMPTY) ? EMPTY : word;
            }
            case 40: {
                return LPAREN;
            }
            case 41: {
                return RPAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        throw new ParseException("expected word but found: " + WellKnownText.tokenString(stream), stream.lineno());
    }

    private static double nextNumber(StreamTokenizer stream) throws IOException, ParseException {
        if (stream.nextToken() == -3) {
            if (stream.sval.equalsIgnoreCase(NAN)) {
                return Double.NaN;
            }
            try {
                return Double.parseDouble(stream.sval);
            }
            catch (NumberFormatException e) {
                throw new ParseException("invalid number found: " + stream.sval, stream.lineno());
            }
        }
        throw new ParseException("expected number but found: " + WellKnownText.tokenString(stream), stream.lineno());
    }

    private static String tokenString(StreamTokenizer stream) {
        return switch (stream.ttype) {
            case -3 -> stream.sval;
            case -1 -> EOF;
            case 10 -> EOL;
            case -2 -> NUMBER;
            default -> "'" + (char)stream.ttype + "'";
        };
    }

    private static boolean isNumberNext(StreamTokenizer stream) throws IOException {
        int type = stream.nextToken();
        stream.pushBack();
        return type == -3;
    }

    private static String nextEmptyOrOpen(StreamTokenizer stream) throws IOException, ParseException {
        String next = WellKnownText.nextWord(stream);
        if (next.equals(EMPTY) || next.equals(LPAREN)) {
            return next;
        }
        throw new ParseException("expected EMPTY or ( but found: " + WellKnownText.tokenString(stream), stream.lineno());
    }

    private static String nextCloser(StreamTokenizer stream) throws IOException, ParseException {
        if (WellKnownText.nextWord(stream).equals(RPAREN)) {
            return RPAREN;
        }
        throw new ParseException("expected ) but found: " + WellKnownText.tokenString(stream), stream.lineno());
    }

    private static String nextComma(StreamTokenizer stream) throws IOException, ParseException {
        if (WellKnownText.nextWord(stream).equals(COMMA)) {
            return COMMA;
        }
        throw new ParseException("expected , but found: " + WellKnownText.tokenString(stream), stream.lineno());
    }

    private static String nextOpener(StreamTokenizer stream) throws IOException, ParseException {
        if (WellKnownText.nextWord(stream).equals(LPAREN)) {
            return LPAREN;
        }
        throw new ParseException("expected ( but found: " + WellKnownText.tokenString(stream), stream.lineno());
    }

    private static String nextCloserOrComma(StreamTokenizer stream) throws IOException, ParseException {
        String token = WellKnownText.nextWord(stream);
        if (token.equals(COMMA) || token.equals(RPAREN)) {
            return token;
        }
        throw new ParseException("expected , or ) but found: " + WellKnownText.tokenString(stream), stream.lineno());
    }

    private static String getWKTName(Geometry geometry) {
        return geometry.visit(new GeometryVisitor<String, RuntimeException>(){

            @Override
            public String visit(Circle circle) {
                return "CIRCLE";
            }

            @Override
            public String visit(GeometryCollection<?> collection) {
                return "GEOMETRYCOLLECTION";
            }

            @Override
            public String visit(Line line) {
                return "LINESTRING";
            }

            @Override
            public String visit(LinearRing ring) {
                throw new UnsupportedOperationException("line ring cannot be serialized using WKT");
            }

            @Override
            public String visit(MultiLine multiLine) {
                return "MULTILINESTRING";
            }

            @Override
            public String visit(MultiPoint multiPoint) {
                return "MULTIPOINT";
            }

            @Override
            public String visit(MultiPolygon multiPolygon) {
                return "MULTIPOLYGON";
            }

            @Override
            public String visit(Point point) {
                return "POINT";
            }

            @Override
            public String visit(Polygon polygon) {
                return "POLYGON";
            }

            @Override
            public String visit(Rectangle rectangle) {
                return "BBOX";
            }
        });
    }

    private static double[] toArray(ArrayList<Double> doubles) {
        return doubles.stream().mapToDouble(i -> i).toArray();
    }
}

