/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.component.csw;

import bak.pcj.map.ObjectKeyIntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.NotImplementedException;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.csw.common.exceptions.OperationNotSupportedEx;
import org.fao.geonet.kernel.csw.CatalogConfiguration;
import org.fao.geonet.kernel.csw.CatalogService;
import org.fao.geonet.kernel.csw.services.AbstractOperation;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="CswService.GetDomain")
public class GetDomain
extends AbstractOperation
implements CatalogService {
    static final String NAME = "GetDomain";
    @Autowired
    private ApplicationContext springAppContext;
    @Autowired
    private CatalogConfiguration _catalogConfig;

    public static List<Element> handlePropertyName(CatalogConfiguration catalogConfig, String[] propertyNames, ServiceContext context, boolean freq, int maxRecords) throws Exception {
        int i;
        ArrayList<Element> domainValuesList = new ArrayList<Element>();
        if (Log.isDebugEnabled((String)"geonetwork.csw")) {
            Log.debug((String)"geonetwork.csw", (Object)("Handling property names '" + Arrays.toString(propertyNames) + "' with max records of " + maxRecords));
        }
        if ((i = 0) < propertyNames.length) {
            Object listOfValues = null;
            Element domainValues = new Element("DomainValues", Csw.NAMESPACE_CSW);
            domainValues.setAttribute("type", "csw:Record");
            String property = propertyNames[i].trim();
            Element pn = new Element("PropertyName", Csw.NAMESPACE_CSW);
            domainValues.addContent((Content)pn.setText(property));
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            EsSearchManager sm = (EsSearchManager)gc.getBean(EsSearchManager.class);
            throw new NotImplementedException("CSW GetDomain operation not implemented in ES");
        }
        return domainValuesList;
    }

    private static void addtoSortedSet(SortedSet<String> sortedValues, String[] fieldValues, ObjectKeyIntOpenHashMap duplicateValues) {
        for (String value : fieldValues) {
            sortedValues.add(value);
            if (duplicateValues.containsKey((Object)value)) {
                int nb = duplicateValues.get((Object)value);
                duplicateValues.remove((Object)value);
                duplicateValues.put((Object)value, nb + 1);
                continue;
            }
            duplicateValues.put((Object)value, 1);
        }
    }

    private static List<Element> createValuesElement(SortedSet<String> sortedValues, boolean isRange) {
        ArrayList<Element> valuesList = new ArrayList<Element>();
        if (!isRange) {
            for (String value : sortedValues) {
                valuesList.add(new Element("Value", Csw.NAMESPACE_CSW).setText(value));
            }
        } else {
            valuesList.add(new Element("MinValue", Csw.NAMESPACE_CSW).setText(sortedValues.first()));
            valuesList.add(new Element("MaxValue", Csw.NAMESPACE_CSW).setText(sortedValues.last()));
        }
        return valuesList;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element execute(Element request, ServiceContext context) throws CatalogException {
        this.checkService(request);
        this.checkVersion(request);
        Element response = new Element(this.getName() + "Response", Csw.NAMESPACE_CSW);
        String[] propertyNames = this.getParameters(request, "PropertyName");
        String[] parameterNames = this.getParameters(request, "ParameterName");
        if (propertyNames != null) {
            List<Element> domainValues;
            try {
                int maxNumberOfRecordsForPropertyNames = this._catalogConfig.getMaxNumberOfRecordsForPropertyNames();
                domainValues = GetDomain.handlePropertyName(this._catalogConfig, propertyNames, context, false, maxNumberOfRecordsForPropertyNames);
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.csw", (Object)("Error getting domain value for specified PropertyName : " + e));
                throw new NoApplicableCodeEx("Raised exception while getting domain value for specified PropertyName  : " + e);
            }
            response.addContent(domainValues);
            return response;
        }
        if (parameterNames != null) {
            List<Element> domainValues = this.handleParameterName(parameterNames);
            response.addContent(domainValues);
        }
        return response;
    }

    @Override
    public Element adaptGetRequest(Map<String, String> params) {
        String service = params.get("service");
        String version = params.get("version");
        String parameterName = params.get("parametername");
        String propertyName = params.get("propertyname");
        Element request = new Element(this.getName(), Csw.NAMESPACE_CSW);
        this.setAttrib(request, "service", service);
        this.setAttrib(request, "version", version);
        Element propName = new Element("PropertyName", Csw.NAMESPACE_CSW).setText(propertyName);
        Element paramName = new Element("ParameterName", Csw.NAMESPACE_CSW).setText(parameterName);
        if (propertyName != null && !propertyName.equals("")) {
            request.addContent((Content)propName);
        } else if (parameterName != null && !parameterName.equals("")) {
            request.addContent((Content)paramName);
        }
        return request;
    }

    @Override
    public Element retrieveValues(String parameterName) throws CatalogException {
        return null;
    }

    private List<Element> handleParameterName(String[] parameterNames) throws CatalogException {
        ArrayList<Element> domainValuesList = null;
        for (int i = 0; i < parameterNames.length; ++i) {
            if (i == 0) {
                domainValuesList = new ArrayList<Element>();
            }
            Element domainValues = new Element("DomainValues", Csw.NAMESPACE_CSW);
            domainValues.setAttribute("type", "csw:Record");
            String paramName = parameterNames[i];
            Element pn = new Element("ParameterName", Csw.NAMESPACE_CSW);
            domainValues.addContent((Content)pn.setText(paramName));
            String operationName = paramName.substring(0, paramName.indexOf(46));
            String parameterName = paramName.substring(paramName.indexOf(46) + 1);
            CatalogService cs = this.checkOperation(operationName);
            Element values = cs.retrieveValues(parameterName);
            if (values != null) {
                domainValues.addContent((Content)values);
            }
            domainValuesList.add(domainValues);
        }
        return domainValuesList;
    }

    private CatalogService checkOperation(String operationName) throws CatalogException {
        CatalogService cs = (CatalogService)this.springAppContext.getBean("CswService." + operationName, CatalogService.class);
        if (cs == null) {
            throw new OperationNotSupportedEx(operationName);
        }
        return cs;
    }

    private String[] getParameters(Element request, String parameter) {
        if (request == null) {
            return null;
        }
        Element paramElt = request.getChild(parameter, Csw.NAMESPACE_CSW);
        if (paramElt == null) {
            return null;
        }
        String parameterName = paramElt.getText();
        return parameterName.split(",");
    }
}

