/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;

public class TaskTransportChannel
implements TransportChannel {
    private final long taskId;
    private final TransportChannel channel;
    private final Releasable onTaskFinished;

    TaskTransportChannel(long taskId, TransportChannel channel, Releasable onTaskFinished) {
        this.taskId = taskId;
        this.channel = channel;
        this.onTaskFinished = onTaskFinished;
    }

    @Override
    public String getProfileName() {
        return this.channel.getProfileName();
    }

    @Override
    public void sendResponse(TransportResponse response) {
        try {
            this.channel.sendResponse(response);
        }
        finally {
            this.onTaskFinished.close();
        }
    }

    @Override
    public void sendResponse(Exception exception) {
        try {
            this.channel.sendResponse(exception);
        }
        finally {
            this.onTaskFinished.close();
        }
    }

    @Override
    public TransportVersion getVersion() {
        return this.channel.getVersion();
    }

    public TransportChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return Strings.format("TaskTransportChannel{task=%d}{%s}", this.taskId, this.channel);
    }
}

