/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.search.lookup.FieldLookup;
import org.elasticsearch.search.lookup.LeafFieldLookupProvider;

class PreloadedFieldLookupProvider
implements LeafFieldLookupProvider {
    private final SetOnce<Set<String>> preloadedStoredFieldNames = new SetOnce();
    private Map<String, List<Object>> preloadedStoredFieldValues;
    private String id;
    private LeafFieldLookupProvider backUpLoader;
    private Supplier<LeafFieldLookupProvider> loaderSupplier;

    PreloadedFieldLookupProvider() {
    }

    @Override
    public void populateFieldLookup(FieldLookup fieldLookup, int doc) throws IOException {
        String field = fieldLookup.fieldType().name();
        if (field.equals("_id")) {
            fieldLookup.setValues(Collections.singletonList(this.id));
            return;
        }
        if (((Set)this.preloadedStoredFieldNames.get()).contains(field)) {
            fieldLookup.setValues(this.preloadedStoredFieldValues.get(field));
            return;
        }
        if (this.backUpLoader == null) {
            this.backUpLoader = this.loaderSupplier.get();
        }
        this.backUpLoader.populateFieldLookup(fieldLookup, doc);
    }

    void setPreloadedStoredFieldNames(Set<String> preloadedStoredFieldNames) {
        this.preloadedStoredFieldNames.set(preloadedStoredFieldNames);
    }

    void setPreloadedStoredFieldValues(String id, Map<String, List<Object>> preloadedStoredFieldValues) {
        assert (((Set)this.preloadedStoredFieldNames.get()).containsAll(preloadedStoredFieldValues.keySet())) : "Provided stored field that was not expected to be preloaded? " + preloadedStoredFieldValues.keySet() + " - " + this.preloadedStoredFieldNames;
        this.preloadedStoredFieldValues = preloadedStoredFieldValues;
        this.id = id;
    }

    void setNextReader(LeafReaderContext ctx) {
        this.backUpLoader = null;
        this.loaderSupplier = () -> LeafFieldLookupProvider.fromStoredFields().apply(ctx);
    }

    LeafFieldLookupProvider getBackUpLoader() {
        return this.backUpLoader;
    }
}

