/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.MedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalMedianAbsoluteDeviation
extends InternalNumericMetricsAggregation.SingleValue
implements MedianAbsoluteDeviation {
    private final TDigestState valuesSketch;
    private final double medianAbsoluteDeviation;

    public static double computeMedianAbsoluteDeviation(TDigestState valuesSketch) {
        if (valuesSketch.size() == 0L) {
            return Double.NaN;
        }
        double approximateMedian = valuesSketch.quantile(0.5);
        TDigestState approximatedDeviationsSketch = TDigestState.createUsingParamsFrom(valuesSketch);
        valuesSketch.centroids().forEach(centroid -> {
            double deviation = Math.abs(approximateMedian - centroid.mean());
            approximatedDeviationsSketch.add(deviation, centroid.count());
        });
        return approximatedDeviationsSketch.quantile(0.5);
    }

    InternalMedianAbsoluteDeviation(String name, Map<String, Object> metadata, DocValueFormat format, TDigestState valuesSketch) {
        super(name, Objects.requireNonNull(format), metadata);
        this.valuesSketch = Objects.requireNonNull(valuesSketch);
        this.medianAbsoluteDeviation = InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation(this.valuesSketch);
    }

    public InternalMedianAbsoluteDeviation(StreamInput in) throws IOException {
        super(in);
        this.valuesSketch = TDigestState.read(in);
        this.medianAbsoluteDeviation = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        TDigestState.write(this.valuesSketch, out);
        out.writeDouble(this.medianAbsoluteDeviation);
    }

    static InternalMedianAbsoluteDeviation empty(String name, Map<String, Object> metadata, DocValueFormat format, double compression, TDigestExecutionHint executionHint) {
        return new InternalMedianAbsoluteDeviation(name, metadata, format, TDigestState.create(compression, executionHint));
    }

    @Override
    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            final TDigestState valueMerged;
            {
                this.valueMerged = TDigestState.createUsingParamsFrom(InternalMedianAbsoluteDeviation.this.valuesSketch);
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                this.valueMerged.add(((InternalMedianAbsoluteDeviation)aggregation).valuesSketch);
            }

            @Override
            public InternalAggregation get() {
                return new InternalMedianAbsoluteDeviation(InternalMedianAbsoluteDeviation.this.name, InternalMedianAbsoluteDeviation.this.metadata, InternalMedianAbsoluteDeviation.this.format, this.valueMerged);
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean anyResults = this.valuesSketch.size() > 0L;
        Double mad = anyResults ? Double.valueOf(this.getMedianAbsoluteDeviation()) : null;
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), mad);
        if (this.format != DocValueFormat.RAW && anyResults) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(mad).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.valuesSketch);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalMedianAbsoluteDeviation other = (InternalMedianAbsoluteDeviation)obj;
        return Objects.equals(this.valuesSketch, other.valuesSketch);
    }

    @Override
    public String getWriteableName() {
        return "median_absolute_deviation";
    }

    TDigestState getValuesSketch() {
        return this.valuesSketch;
    }

    @Override
    public double value() {
        return this.getMedianAbsoluteDeviation();
    }

    @Override
    public double getMedianAbsoluteDeviation() {
        return this.medianAbsoluteDeviation;
    }
}

