/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.util.Objects;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.LongCounter;

public class CircuitBreakerMetrics {
    public static final CircuitBreakerMetrics NOOP = new CircuitBreakerMetrics(TelemetryProvider.NOOP);
    public static final String ES_BREAKER_TRIP_COUNT_TOTAL = "es.breaker.trip.total";
    private final LongCounter tripCount;

    private CircuitBreakerMetrics(LongCounter tripCount) {
        this.tripCount = tripCount;
    }

    public CircuitBreakerMetrics(TelemetryProvider telemetryProvider) {
        this(telemetryProvider.getMeterRegistry().registerLongCounter(ES_BREAKER_TRIP_COUNT_TOTAL, "Circuit breaker trip count", "count"));
    }

    public LongCounter getTripCount() {
        return this.tripCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CircuitBreakerMetrics that = (CircuitBreakerMetrics)o;
        return Objects.equals(this.tripCount, that.tripCount);
    }

    public int hashCode() {
        return Objects.hash(this.tripCount);
    }

    public String toString() {
        return "CircuitBreakerMetrics{, tripCount=" + this.tripCount + "}";
    }
}

