/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.health.node.DataStreamLifecycleHealthInfo;
import org.elasticsearch.health.node.DiskHealthInfo;
import org.elasticsearch.health.node.RepositoriesHealthInfo;

public record HealthInfo(Map<String, DiskHealthInfo> diskInfoByNode, @Nullable DataStreamLifecycleHealthInfo dslHealthInfo, Map<String, RepositoriesHealthInfo> repositoriesInfoByNode) implements Writeable
{
    public static final HealthInfo EMPTY_HEALTH_INFO = new HealthInfo(Map.of(), DataStreamLifecycleHealthInfo.NO_DSL_ERRORS, Map.of());

    public HealthInfo(StreamInput input) throws IOException {
        this(input.readMap(DiskHealthInfo::new), input.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? input.readOptionalWriteable(DataStreamLifecycleHealthInfo::new) : null, input.getTransportVersion().onOrAfter(TransportVersions.HEALTH_INFO_ENRICHED_WITH_REPOS) ? input.readMap(RepositoriesHealthInfo::new) : Map.of());
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        output.writeMap(this.diskInfoByNode, StreamOutput::writeWriteable);
        if (output.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            output.writeOptionalWriteable(this.dslHealthInfo);
        }
        if (output.getTransportVersion().onOrAfter(TransportVersions.HEALTH_INFO_ENRICHED_WITH_REPOS)) {
            output.writeMap(this.repositoriesInfoByNode, StreamOutput::writeWriteable);
        }
    }
}

