/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.plugins.internal.DocumentSizeObserver;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class XContentHelper {
    @Deprecated
    public static XContentParser createParser(NamedXContentRegistry registry, DeprecationHandler deprecation, BytesReference bytes) throws IOException {
        return XContentHelper.createParser(XContentParserConfiguration.EMPTY.withRegistry(registry).withDeprecationHandler(deprecation), bytes);
    }

    @Deprecated
    public static XContentParser createParser(XContentParserConfiguration config, BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            InputStream compressedInput = compressor.threadLocalInputStream(bytes.streamInput());
            if (!compressedInput.markSupported()) {
                compressedInput = new BufferedInputStream(compressedInput);
            }
            XContentType contentType = XContentFactory.xContentType((InputStream)compressedInput);
            return XContentFactory.xContent((XContentType)contentType).createParser(config, compressedInput);
        }
        return XContentHelper.createParserNotCompressed(config, bytes, XContentHelper.xContentType(bytes));
    }

    public static XContentParser createParserNotCompressed(XContentParserConfiguration config, BytesReference bytes, XContentType xContentType) throws IOException {
        XContent xContent = xContentType.xContent();
        if (bytes.hasArray()) {
            return xContent.createParser(config, bytes.array(), bytes.arrayOffset(), bytes.length());
        }
        return xContent.createParser(config, (InputStream)bytes.streamInput());
    }

    @Deprecated
    public static XContentParser createParser(NamedXContentRegistry registry, DeprecationHandler deprecation, BytesReference bytes, XContentType xContentType) throws IOException {
        return XContentHelper.createParser(XContentParserConfiguration.EMPTY.withRegistry(registry).withDeprecationHandler(deprecation), bytes, xContentType);
    }

    public static XContentParser createParser(XContentParserConfiguration config, BytesReference bytes, XContentType xContentType) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            return XContentFactory.xContent((XContentType)xContentType).createParser(config, compressor.threadLocalInputStream(bytes.streamInput()));
        }
        return XContentHelper.createParserNotCompressed(config, bytes, xContentType);
    }

    @Deprecated
    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered) throws ElasticsearchParseException {
        return XContentHelper.parseToType(ordered ? XContentParser::mapOrdered : XContentParser::map, bytes, null, XContentParserConfiguration.EMPTY);
    }

    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, XContentType xContentType, DocumentSizeObserver documentSizeObserver) {
        return XContentHelper.parseToType(ordered ? XContentParser::mapOrdered : XContentParser::map, bytes, xContentType, XContentParserConfiguration.EMPTY, documentSizeObserver);
    }

    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, XContentType xContentType) {
        return XContentHelper.parseToType(ordered ? XContentParser::mapOrdered : XContentParser::map, bytes, xContentType, XContentParserConfiguration.EMPTY);
    }

    public static Tuple<XContentType, Map<String, Object>> convertToMap(BytesReference bytes, boolean ordered, XContentType xContentType, @Nullable Set<String> include, @Nullable Set<String> exclude) throws ElasticsearchParseException {
        XContentParserConfiguration config = XContentParserConfiguration.EMPTY;
        if (include != null || exclude != null) {
            config = config.withFiltering(include, exclude, false);
        }
        return XContentHelper.parseToType(ordered ? XContentParser::mapOrdered : XContentParser::map, bytes, xContentType, config);
    }

    @Deprecated
    public static <T> Tuple<XContentType, T> parseToType(CheckedFunction<XContentParser, T, IOException> extractor, BytesReference bytes, @Nullable XContentType xContentType, @Nullable XContentParserConfiguration config) throws ElasticsearchParseException {
        return XContentHelper.parseToType(extractor, bytes, xContentType, config, DocumentSizeObserver.EMPTY_INSTANCE);
    }

    public static <T> Tuple<XContentType, T> parseToType(CheckedFunction<XContentParser, T, IOException> extractor, BytesReference bytes, @Nullable XContentType xContentType, @Nullable XContentParserConfiguration config, DocumentSizeObserver documentSizeObserver) throws ElasticsearchParseException {
        Tuple tuple;
        block8: {
            config = config != null ? config : XContentParserConfiguration.EMPTY;
            XContentParser parser = documentSizeObserver.wrapParser(xContentType != null ? XContentHelper.createParser(config, bytes, xContentType) : XContentHelper.createParser(config, bytes));
            try {
                Tuple xContentTypeTTuple;
                tuple = xContentTypeTTuple = new Tuple((Object)parser.contentType(), extractor.apply((Object)parser));
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to type", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return tuple;
    }

    public static Map<String, Object> convertToMap(XContent xContent, String string, boolean ordered) throws ElasticsearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY, string);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, InputStream input, boolean ordered) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(xContent, input, ordered, null, null);
    }

    public static Map<String, Object> convertToMap(XContent xContent, InputStream input, boolean ordered, @Nullable Set<String> include, @Nullable Set<String> exclude) throws ElasticsearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY.withFiltering(include, exclude, false), input);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    public static Map<String, Object> convertToMap(XContent xContent, byte[] bytes, int offset, int length, boolean ordered) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(xContent, bytes, offset, length, ordered, null, null);
    }

    public static Map<String, Object> convertToMap(XContent xContent, byte[] bytes, int offset, int length, boolean ordered, @Nullable Set<String> include, @Nullable Set<String> exclude) throws ElasticsearchParseException {
        Map map;
        block8: {
            XContentParser parser = xContent.createParser(XContentParserConfiguration.EMPTY.withFiltering(include, exclude, false), bytes, offset, length);
            try {
                Map map2 = map = ordered ? parser.mapOrdered() : parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return map;
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false);
    }

    @Deprecated
    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, prettyPrint, XContentHelper.xContentType(bytes));
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, XContentType xContentType) throws IOException {
        return XContentHelper.convertToJson(bytes, reformatJson, false, xContentType);
    }

    public static String stripWhitespace(String json) throws IOException {
        return XContentHelper.convertToJson((BytesReference)new BytesArray(json), true, XContentType.JSON);
    }

    public static String convertToJson(BytesReference bytes, boolean reformatJson, boolean prettyPrint, XContentType xContentType) throws IOException {
        Objects.requireNonNull(xContentType);
        if (xContentType.canonical() == XContentType.JSON && !reformatJson) {
            return bytes.utf8ToString();
        }
        try (XContentParser parser = XContentHelper.createParserNotCompressed(XContentParserConfiguration.EMPTY, bytes, xContentType);){
            String string = XContentHelper.toJsonString(prettyPrint, parser);
            return string;
        }
    }

    private static String toJsonString(boolean prettyPrint, XContentParser parser) throws IOException {
        parser.nextToken();
        XContentBuilder builder = XContentFactory.jsonBuilder();
        if (prettyPrint) {
            builder.prettyPrint();
        }
        builder.copyCurrentStructure(parser);
        return Strings.toString(builder);
    }

    public static boolean update(Map<String, Object> source, Map<String, Object> changes, boolean checkUpdatesAreUnequal) {
        boolean modified = false;
        for (Map.Entry<String, Object> changesEntry : changes.entrySet()) {
            if (!source.containsKey(changesEntry.getKey())) {
                source.put(changesEntry.getKey(), changesEntry.getValue());
                modified = true;
                continue;
            }
            Object old = source.get(changesEntry.getKey());
            if (old instanceof Map && changesEntry.getValue() instanceof Map) {
                modified |= XContentHelper.update((Map)source.get(changesEntry.getKey()), (Map)changesEntry.getValue(), checkUpdatesAreUnequal && !modified);
                continue;
            }
            source.put(changesEntry.getKey(), changesEntry.getValue());
            if (modified) continue;
            if (!checkUpdatesAreUnequal) {
                modified = true;
                continue;
            }
            modified = !Objects.equals(old, changesEntry.getValue());
        }
        return modified;
    }

    public static void mergeDefaults(Map<String, Object> content, Map<String, Object> defaults) {
        XContentHelper.merge(content, defaults, null);
    }

    public static void merge(Map<String, Object> first, Map<String, Object> second, @Nullable CustomMerge customMerge) {
        XContentHelper.merge(null, first, second, customMerge);
    }

    public static void merge(@Nullable String parent, Map<String, Object> first, Map<String, Object> second, @Nullable CustomMerge customMerge) {
        for (Map.Entry<String, Object> toMergeEntry : second.entrySet()) {
            Object mergedValue;
            if (!first.containsKey(toMergeEntry.getKey())) {
                first.put(toMergeEntry.getKey(), toMergeEntry.getValue());
                continue;
            }
            Object baseValue = first.get(toMergeEntry.getKey());
            if (baseValue instanceof Map && toMergeEntry.getValue() instanceof Map) {
                mergedValue = null;
                if (customMerge != null) {
                    Object tmp = customMerge.merge(parent, toMergeEntry.getKey(), baseValue, toMergeEntry.getValue());
                    if (tmp != null && !(tmp instanceof Map)) {
                        throw new IllegalStateException("merging of values for [" + toMergeEntry.getKey() + "] must yield a map");
                    }
                    mergedValue = (Map)tmp;
                }
                if (mergedValue != null) {
                    first.put(toMergeEntry.getKey(), mergedValue);
                    continue;
                }
                XContentHelper.merge(toMergeEntry.getKey(), (Map)baseValue, (Map)toMergeEntry.getValue(), customMerge);
                continue;
            }
            if (baseValue instanceof List && toMergeEntry.getValue() instanceof List) {
                List listToMerge = (List)toMergeEntry.getValue();
                List baseList = (List)baseValue;
                if (XContentHelper.allListValuesAreMapsOfOne(listToMerge) && XContentHelper.allListValuesAreMapsOfOne(baseList)) {
                    Map.Entry entry;
                    Map map;
                    LinkedHashMap<String, Map> processed = new LinkedHashMap<String, Map>();
                    for (Object o : baseList) {
                        map = (Map)o;
                        entry = map.entrySet().iterator().next();
                        processed.put((String)entry.getKey(), map);
                    }
                    for (Object o : listToMerge) {
                        map = (Map)o;
                        entry = map.entrySet().iterator().next();
                        if (processed.containsKey(entry.getKey())) {
                            XContentHelper.merge(toMergeEntry.getKey(), (Map)processed.get(entry.getKey()), map, customMerge);
                            continue;
                        }
                        processed.put((String)entry.getKey(), map);
                    }
                    first.put(toMergeEntry.getKey(), new ArrayList(processed.values()));
                    continue;
                }
                ArrayList mergedList = new ArrayList(listToMerge);
                for (Object o : baseList) {
                    if (mergedList.contains(o)) continue;
                    mergedList.add(o);
                }
                first.put(toMergeEntry.getKey(), mergedList);
                continue;
            }
            if (customMerge == null || (mergedValue = customMerge.merge(parent, toMergeEntry.getKey(), baseValue, toMergeEntry.getValue())) == null) continue;
            first.put(toMergeEntry.getKey(), mergedValue);
        }
    }

    private static boolean allListValuesAreMapsOfOne(List<Object> list) {
        for (Object o : list) {
            if (!(o instanceof Map)) {
                return false;
            }
            if (((Map)o).size() == 1) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static void writeRawField(String field, BytesReference source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Compressor compressor = CompressorFactory.compressor(source);
        if (compressor != null) {
            try (InputStream compressedStreamInput = compressor.threadLocalInputStream(source.streamInput());){
                builder.rawField(field, compressedStreamInput);
            }
        }
        try (StreamInput stream = source.streamInput();){
            builder.rawField(field, (InputStream)stream);
        }
    }

    public static void writeRawField(String field, BytesReference source, XContentType xContentType, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Objects.requireNonNull(xContentType);
        Compressor compressor = CompressorFactory.compressor(source);
        if (compressor != null) {
            try (InputStream compressedStreamInput = compressor.threadLocalInputStream(source.streamInput());){
                builder.rawField(field, compressedStreamInput, xContentType);
            }
        }
        try (StreamInput stream = source.streamInput();){
            builder.rawField(field, (InputStream)stream, xContentType);
        }
    }

    public static BytesReference toXContent(ToXContent toXContent, XContentType xContentType, boolean humanReadable) throws IOException {
        return XContentHelper.toXContent(toXContent, xContentType, ToXContent.EMPTY_PARAMS, humanReadable);
    }

    public static BytesReference toXContent(ChunkedToXContent toXContent, XContentType xContentType, boolean humanReadable) throws IOException {
        return XContentHelper.toXContent(ChunkedToXContent.wrapAsToXContent(toXContent), xContentType, humanReadable);
    }

    public static BytesReference toXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable) throws IOException {
        try (XContentBuilder builder = XContentBuilder.builder((XContent)xContentType.xContent());){
            builder.humanReadable(humanReadable);
            if (toXContent.isFragment()) {
                builder.startObject();
            }
            toXContent.toXContent(builder, params);
            if (toXContent.isFragment()) {
                builder.endObject();
            }
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    public static BytesReference toXContent(ChunkedToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable) throws IOException {
        return XContentHelper.toXContent(ChunkedToXContent.wrapAsToXContent(toXContent), xContentType, params, humanReadable);
    }

    @Deprecated
    public static XContentType xContentTypeMayCompressed(BytesReference bytes) {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            try {
                InputStream compressedStreamInput = compressor.threadLocalInputStream(bytes.streamInput());
                if (!compressedStreamInput.markSupported()) {
                    compressedStreamInput = new BufferedInputStream(compressedStreamInput);
                }
                return XContentFactory.xContentType((InputStream)compressedStreamInput);
            }
            catch (IOException e) {
                assert (false) : "Should not happen, we're just reading bytes from memory";
                throw new UncheckedIOException(e);
            }
        }
        return XContentHelper.xContentType(bytes);
    }

    @Deprecated
    public static XContentType xContentType(BytesReference bytes) {
        if (bytes.hasArray()) {
            return XContentFactory.xContentType((byte[])bytes.array(), (int)bytes.arrayOffset(), (int)bytes.length());
        }
        try {
            StreamInput inputStream = bytes.streamInput();
            assert (inputStream.markSupported());
            return XContentFactory.xContentType((InputStream)inputStream);
        }
        catch (IOException e) {
            assert (false) : "Should not happen, we're just reading bytes from memory";
            throw new UncheckedIOException(e);
        }
    }

    public static BytesReference childBytes(XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "Expected [START_OBJECT] but got [" + parser.currentToken() + "]");
        }
        XContentBuilder builder = XContentBuilder.builder((XContent)parser.contentType().xContent());
        builder.copyCurrentStructure(parser);
        return BytesReference.bytes(builder);
    }

    public static void writeTo(StreamOutput out, XContentType xContentType) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeVInt(xContentType.canonical().ordinal());
        } else {
            out.writeVInt(xContentType.ordinal());
        }
    }

    public static XContentParser mapToXContentParser(XContentParserConfiguration config, Map<String, ?> source) {
        XContentParser xContentParser;
        block8: {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            try {
                builder.map(source);
                xContentParser = XContentHelper.createParserNotCompressed(config, BytesReference.bytes(builder), builder.contentType());
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
                }
            }
            builder.close();
        }
        return xContentParser;
    }

    @FunctionalInterface
    public static interface CustomMerge {
        @Nullable
        public Object merge(String var1, String var2, Object var3, Object var4);
    }
}

