/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.util.Maps;

public final class ImmutableOpenMap<KType, VType>
extends AbstractMap<KType, VType> {
    private final ObjectObjectHashMap<KType, VType> map;
    private Set<Map.Entry<KType, VType>> entrySet;
    private static final ImmutableOpenMap EMPTY = new ImmutableOpenMap(new ObjectObjectHashMap());

    private ImmutableOpenMap(ObjectObjectHashMap<KType, VType> map) {
        this.map = map;
    }

    @Override
    public VType get(Object key) {
        return (VType)this.map.get(key);
    }

    @Override
    public VType getOrDefault(Object key, VType defaultValue) {
        return (VType)this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.values().contains(value);
    }

    @Override
    public VType remove(Object key) {
        throw new UnsupportedOperationException("modification is not supported");
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<Map.Entry<KType, VType>> entrySet() {
        Set<Map.Entry<KType, VType>> es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet<KType, VType>(this.map)) : es;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ImmutableOpenMap) {
            ImmutableOpenMap immutableOpenMap = (ImmutableOpenMap)o;
            return this.map.equals(immutableOpenMap.map);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Set<KType> keySet() {
        return new KeySet(this.map.keys());
    }

    @Override
    public Collection<VType> values() {
        return new MapObjectCollection(this.map.values());
    }

    @Override
    public void forEach(BiConsumer<? super KType, ? super VType> action) {
        this.map.forEach(action::accept);
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    public static <KType, VType> ImmutableOpenMap<KType, VType> of() {
        return EMPTY;
    }

    public static <KType, VType> Builder<KType, VType> builder() {
        return new Builder();
    }

    public static <KType, VType> Builder<KType, VType> builder(int size) {
        return new Builder(size);
    }

    public static <KType, VType> Builder<KType, VType> builder(Map<KType, VType> map) {
        if (map instanceof ImmutableOpenMap) {
            ImmutableOpenMap iom = (ImmutableOpenMap)map;
            return new Builder(iom);
        }
        Builder<KType, VType> builder = new Builder<KType, VType>(map.size());
        builder.putAllFromMap(map);
        return builder;
    }

    private static class EntrySet<KType, VType>
    extends AbstractSet<Map.Entry<KType, VType>> {
        private final ObjectObjectHashMap<KType, VType> map;

        private EntrySet(ObjectObjectHashMap<KType, VType> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<KType, VType>> iterator() {
            return Iterators.map(this.map.iterator(), c -> new Maps.ImmutableEntry<Object, Object>(c.key, c.value));
        }

        @Override
        public Spliterator<Map.Entry<KType, VType>> spliterator() {
            return Spliterators.spliterator(this.iterator(), (long)this.size(), 1024);
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<KType, VType>> action) {
            this.map.forEach(c -> action.accept(new Maps.ImmutableEntry<Object, Object>(c.key, c.value)));
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object v = this.map.get(key);
            if (v == null && !this.map.containsKey(key)) {
                return false;
            }
            return Objects.equals(v, e.getValue());
        }

        @Override
        public String toString() {
            return this.map.toString();
        }
    }

    private static class KeySet<KType, VType>
    extends MapObjectCollection<KType>
    implements Set<KType> {
        private KeySet(ObjectObjectHashMap.KeysContainer keys) {
            super(keys);
        }
    }

    private static class MapObjectCollection<Type>
    extends AbstractCollection<Type> {
        private final ObjectCollection<Type> collection;

        private MapObjectCollection(ObjectCollection<Type> collection) {
            this.collection = collection;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public Iterator<Type> iterator() {
            return Iterators.map(this.collection.iterator(), c -> c.value);
        }

        @Override
        public Spliterator<Type> spliterator() {
            return Spliterators.spliterator(this.iterator(), (long)this.size(), 1024);
        }

        @Override
        public void forEach(Consumer<? super Type> action) {
            this.collection.forEach(action::accept);
        }

        @Override
        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        @Override
        public boolean equals(Object obj) {
            return this.collection.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        public String toString() {
            return this.collection.toString();
        }

        @Override
        public Object[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return a.length == 0 ? this.collection.toArray(a.getClass().getComponentType()) : super.toArray(a);
        }
    }

    public static class Builder<KType, VType> {
        private ImmutableOpenMap<KType, VType> reference;
        private ObjectObjectHashMap<KType, VType> mutableMap;

        private void maybeCloneMap() {
            if (this.reference != null) {
                this.mutableMap = this.reference.map.clone();
                this.reference = null;
            }
        }

        public Builder() {
            this(EMPTY);
        }

        public Builder(int size) {
            this.mutableMap = new ObjectObjectHashMap(size);
        }

        public Builder(ImmutableOpenMap<KType, VType> immutableOpenMap) {
            this.reference = Objects.requireNonNull(immutableOpenMap);
        }

        public ImmutableOpenMap<KType, VType> build() {
            if (this.reference != null) {
                ImmutableOpenMap<KType, VType> reference = this.reference;
                this.reference = null;
                return reference;
            }
            ObjectObjectHashMap<KType, VType> mutableMap = this.mutableMap;
            this.mutableMap = null;
            return mutableMap.isEmpty() ? ImmutableOpenMap.of() : new ImmutableOpenMap<KType, VType>(mutableMap);
        }

        public Builder<KType, VType> putAllFromMap(Map<KType, VType> map) {
            this.maybeCloneMap();
            map.forEach((arg_0, arg_1) -> this.mutableMap.put(arg_0, arg_1));
            return this;
        }

        public Builder<KType, VType> fPut(KType key, VType value) {
            this.maybeCloneMap();
            this.mutableMap.put(key, value);
            return this;
        }

        public VType put(KType key, VType value) {
            this.maybeCloneMap();
            return (VType)this.mutableMap.put(key, value);
        }

        public VType get(KType key) {
            this.maybeCloneMap();
            return (VType)this.mutableMap.get(key);
        }

        public VType getOrDefault(KType kType, VType vType) {
            this.maybeCloneMap();
            return (VType)this.mutableMap.getOrDefault(kType, vType);
        }

        public VType remove(KType key) {
            this.maybeCloneMap();
            return (VType)this.mutableMap.remove(key);
        }

        public boolean containsKey(KType key) {
            this.maybeCloneMap();
            return this.mutableMap.containsKey(key);
        }

        public int size() {
            this.maybeCloneMap();
            return this.mutableMap.size();
        }

        public void clear() {
            this.maybeCloneMap();
            this.mutableMap.clear();
        }

        public Set<KType> keys() {
            this.maybeCloneMap();
            return new KeySet(this.mutableMap.keys());
        }

        public int removeAll(BiPredicate<? super KType, ? super VType> predicate) {
            this.maybeCloneMap();
            return this.mutableMap.removeAll(predicate::test);
        }
    }
}

