/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.MultiTermVectorsShardRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsShardResponse;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.termvectors.TermVectorsService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardMultiTermsVectorAction
extends TransportSingleShardAction<MultiTermVectorsShardRequest, MultiTermVectorsShardResponse> {
    private final IndicesService indicesService;
    private static final String ACTION_NAME = "indices:data/read/mtv[shard]";
    public static final ActionType<MultiTermVectorsShardResponse> TYPE = new ActionType("indices:data/read/mtv[shard]");

    @Inject
    public TransportShardMultiTermsVectorAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, MultiTermVectorsShardRequest::new, threadPool.executor("get"));
        this.indicesService = indicesService;
    }

    @Override
    protected boolean isSubAction() {
        return true;
    }

    @Override
    protected Writeable.Reader<MultiTermVectorsShardResponse> getResponseReader() {
        return MultiTermVectorsShardResponse::new;
    }

    @Override
    protected boolean resolveIndex(MultiTermVectorsShardRequest request) {
        return false;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ShardIterator shards = this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((MultiTermVectorsShardRequest)request.request()).shardId(), ((MultiTermVectorsShardRequest)request.request()).preference());
        return this.clusterService.operationRouting().useOnlyPromotableShardsForStateless(shards);
    }

    @Override
    protected MultiTermVectorsShardResponse shardOperation(MultiTermVectorsShardRequest request, ShardId shardId) {
        MultiTermVectorsShardResponse response = new MultiTermVectorsShardResponse();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        for (int i = 0; i < request.locations.size(); ++i) {
            TermVectorsRequest termVectorsRequest = request.requests.get(i);
            try {
                TermVectorsResponse termVectorsResponse = TermVectorsService.getTermVectors(indexShard, termVectorsRequest);
                response.add((int)request.locations.get(i), termVectorsResponse);
                continue;
            }
            catch (RuntimeException e) {
                if (TransportActions.isShardNotAvailableException(e)) {
                    throw e;
                }
                this.logger.debug(() -> Strings.format((String)"%s failed to execute multi term vectors for [%s]", (Object[])new Object[]{shardId, termVectorsRequest.id()}), (Throwable)e);
                response.add((int)request.locations.get(i), new MultiTermVectorsResponse.Failure(request.index(), termVectorsRequest.id(), e));
            }
        }
        return response;
    }

    @Override
    protected Executor getExecutor(MultiTermVectorsShardRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? this.threadPool.executor("search_throttled") : super.getExecutor(request, shardId);
    }
}

