/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.put;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class UpdateSettingsRequest
extends AcknowledgedRequest<UpdateSettingsRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, true, true);
    private String[] indices;
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
    private Settings settings = Settings.EMPTY;
    private boolean preserveExisting = false;
    private String origin = "";
    private boolean reopen = false;

    public UpdateSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.settings = Settings.readSettingsFromStream(in);
        this.preserveExisting = in.readBoolean();
        this.origin = in.readString();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            this.reopen = in.readBoolean();
        }
    }

    public UpdateSettingsRequest() {
    }

    public UpdateSettingsRequest(String ... indices) {
        this.indices = indices;
    }

    public UpdateSettingsRequest(Settings settings, String ... indices) {
        this.indices = indices;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.settings.isEmpty()) {
            validationException = ValidateActions.addValidationError("no settings to update", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public UpdateSettingsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public UpdateSettingsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public UpdateSettingsRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public UpdateSettingsRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public UpdateSettingsRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public boolean isPreserveExisting() {
        return this.preserveExisting;
    }

    public UpdateSettingsRequest setPreserveExisting(boolean preserveExisting) {
        this.preserveExisting = preserveExisting;
        return this;
    }

    public UpdateSettingsRequest settings(Map<String, ?> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public UpdateSettingsRequest origin(String origin) {
        this.origin = Objects.requireNonNull(origin, "origin cannot be null");
        return this;
    }

    public boolean reopen() {
        return this.reopen;
    }

    public void reopen(boolean reopen) {
        this.reopen = reopen;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        this.settings.writeTo(out);
        out.writeBoolean(this.preserveExisting);
        out.writeString(this.origin);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeBoolean(this.reopen);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.settings.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public UpdateSettingsRequest fromXContent(XContentParser parser) throws IOException {
        HashMap settings = new HashMap();
        Map bodySettings = parser.map();
        Object innerBodySettings = bodySettings.get("settings");
        if (innerBodySettings instanceof Map) {
            Map innerBodySettingsMap = (Map)innerBodySettings;
            settings.putAll(innerBodySettingsMap);
            UpdateSettingsRequest.checkMixedRequest(bodySettings);
        } else {
            settings.putAll(bodySettings);
        }
        return this.settings(settings);
    }

    private static void checkMixedRequest(Map<String, Object> bodySettings) {
        assert (bodySettings.containsKey("settings"));
        if (bodySettings.size() > 1) {
            throw new ElasticsearchParseException("mix of settings map and top-level properties", new Object[0]);
        }
    }

    @Override
    public String toString() {
        return "indices : " + Arrays.toString(this.indices) + "," + Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSettingsRequest that = (UpdateSettingsRequest)o;
        return this.masterNodeTimeout.equals((Object)that.masterNodeTimeout) && this.timeout.equals((Object)that.timeout) && Objects.equals(this.settings, that.settings) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.preserveExisting, that.preserveExisting) && Objects.equals(this.reopen, that.reopen) && Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.masterNodeTimeout, this.timeout, this.settings, this.indicesOptions, this.preserveExisting, this.reopen, Arrays.hashCode(this.indices));
    }
}

