/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.InspireAtomFeedEntry;
import org.fao.geonet.exceptions.ResourceNotFoundEx;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.inspireatom.InspireAtomService;
import org.fao.geonet.inspireatom.harvester.InspireAtomHarvester;
import org.fao.geonet.inspireatom.model.DatasetFeedInfo;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/atom"})
@Tag(name="atom", description="ATOM")
@RestController
public class AtomServiceDescription {
    @Autowired
    InspireAtomService service;
    @Autowired
    SettingManager sm;
    @Autowired
    DataManager dm;
    @Autowired
    InspireAtomFeedRepository inspireAtomFeedRepository;

    @Operation(summary="Describe service", description="")
    @GetMapping(value={"/describe/service/{metadataUuid}"}, produces={"application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Feeds."), @ApiResponse(responseCode="204", description="Not authenticated.", content={@io.swagger.v3.oas.annotations.media.Content(schema=@Schema(hidden=true))})})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Element describe(@Parameter(description="metadataUuid", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String atomUrl;
        InspireAtomHarvester inspireAtomHarvester;
        AbstractMetadata metadataRecord;
        ServiceContext context = ApiUtils.createServiceContext((HttpServletRequest)request);
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        boolean inspireEnable = this.sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"Inspire is disabled");
            throw new Exception("Inspire is disabled");
        }
        try {
            metadataRecord = ApiUtils.canViewRecord((String)metadataUuid, (HttpServletRequest)request);
        }
        catch (ResourceNotFoundException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        Element md = metadataRecord.getXmlData(false);
        String schema = metadataRecord.getDataInfo().getSchemaId();
        String id = String.valueOf(metadataRecord.getId());
        String atomProtocol = this.sm.getValue("system/inspire/atomProtocol");
        if (!InspireAtomUtil.isServiceMetadata(this.dm, schema, md)) {
            throw new Exception("No service metadata found with uuid:" + metadataUuid);
        }
        InspireAtomFeed inspireAtomFeed = this.service.findByMetadataId(Integer.parseInt(id));
        if (inspireAtomFeed == null) {
            String serviceFeedUrl = InspireAtomUtil.extractAtomFeedUrl(schema, md, this.dm, atomProtocol);
            if (StringUtils.isEmpty((String)serviceFeedUrl)) {
                throw new ResourceNotFoundEx("No atom feed for service metadata found with uuid:" + metadataUuid);
            }
            inspireAtomHarvester = new InspireAtomHarvester(gc);
            inspireAtomHarvester.harvestServiceMetadata(context, id);
            inspireAtomFeed = this.service.findByMetadataId(Integer.parseInt(id));
            if (inspireAtomFeed == null) {
                throw new ResourceNotFoundEx("No atom feed for service metadata found with uuid:" + metadataUuid);
            }
        }
        if (StringUtils.isEmpty((String)(atomUrl = inspireAtomFeed.getAtomUrl()))) {
            atomUrl = InspireAtomUtil.extractAtomFeedUrl(schema, md, this.dm, atomProtocol);
            if (StringUtils.isEmpty((String)atomUrl)) {
                throw new Exception("Metadata has no atom feed");
            }
            inspireAtomHarvester = new InspireAtomHarvester(gc);
            inspireAtomHarvester.harvestServiceMetadata(context, id);
            inspireAtomFeed = this.service.findByMetadataId(Integer.parseInt(id));
        }
        List<DatasetFeedInfo> datasetsInformation = InspireAtomUtil.extractRelatedDatasetsInfoFromServiceFeed(inspireAtomFeed.getAtom(), this.dm);
        String feedAuthorName = inspireAtomFeed.getAuthorName();
        String feedTitle = inspireAtomFeed.getTitle();
        String feedSubtitle = inspireAtomFeed.getSubtitle();
        String feedLang = inspireAtomFeed.getLang();
        String feedUrl = inspireAtomFeed.getAtomUrl();
        List<String> keywords = InspireAtomUtil.retrieveKeywordsFromFileIdentifier(context, metadataUuid);
        Element datasetsEl = this.processDatasetsInfo(datasetsInformation, metadataUuid);
        Element response = new Element("response").addContent((Content)new Element("fileId").setText(metadataUuid)).addContent((Content)new Element("title").setText(feedTitle)).addContent((Content)new Element("subtitle").setText(feedSubtitle)).addContent((Content)new Element("lang").setText(feedLang)).addContent((Content)new Element("keywords").setText(StringUtils.join(keywords, (String)", "))).addContent((Content)new Element("authorName").setText(feedAuthorName)).addContent((Content)new Element("url").setText(feedUrl)).addContent((Content)datasetsEl);
        return new XsltResponseWriter(null, "opensearch").withXml(response).withXsl("xslt/services/inspire-atom/opensearch.xsl").asElement();
    }

    private Element processDatasetsInfo(List<DatasetFeedInfo> datasetsInformation, String serviceIdentifier) throws Exception {
        Element datasetsEl = new Element("datasets");
        for (DatasetFeedInfo datasetFeedInfo : datasetsInformation) {
            Integer count;
            List inspireAtomFeedList = this.inspireAtomFeedRepository.findAllByAtomDatasetid(datasetFeedInfo.identifier);
            if (inspireAtomFeedList.isEmpty()) {
                Log.warning((String)"geonetwork.atom", (Object)String.format("AtomServiceDescription for service metadata (%s): metadata for dataset identifier %s was not found, ignoring it.", serviceIdentifier, datasetFeedInfo.identifier));
                continue;
            }
            InspireAtomFeed inspireAtomFeed = (InspireAtomFeed)inspireAtomFeedList.get(0);
            String datasetUuid = this.dm.getMetadataUuid(String.valueOf(inspireAtomFeed.getMetadataId()));
            String idNs = inspireAtomFeed.getAtomDatasetid();
            String namespace = inspireAtomFeed.getAtomDatasetns();
            if (StringUtils.isEmpty((String)idNs)) {
                Log.warning((String)"geonetwork.atom", (Object)("AtomServiceDescription for service metadata (" + serviceIdentifier + "): dataset with uuid " + datasetUuid + " has no dataset identifier/namespace, ignoring it."));
                continue;
            }
            String atomUrl = inspireAtomFeed.getAtomUrl();
            if (StringUtils.isEmpty((String)atomUrl)) {
                Log.warning((String)"geonetwork.atom", (Object)("AtomServiceDescription for service metadata (" + serviceIdentifier + "): dataset with uuid " + datasetUuid + " has no dataset feed, ignoring it."));
                continue;
            }
            Element datasetEl = this.buildDatasetInfo(idNs, namespace);
            datasetEl.addContent((Content)new Element("atom_url").setText(atomUrl));
            HashMap<String, Integer> downloadsCountByCrs = new HashMap<String, Integer>();
            for (InspireAtomFeedEntry entry : inspireAtomFeed.getEntryList()) {
                count = (Integer)downloadsCountByCrs.get(entry.getCrs());
                if (count == null) {
                    count = 0;
                }
                downloadsCountByCrs.put(entry.getCrs(), count + 1);
            }
            for (InspireAtomFeedEntry entry : inspireAtomFeed.getEntryList()) {
                count = (Integer)downloadsCountByCrs.get(entry.getCrs());
                if (count == null) continue;
                Element downloadEl = new Element("file");
                downloadEl.addContent((Content)new Element("title").setText(entry.getTitle()));
                downloadEl.addContent((Content)new Element("lang").setText(entry.getLang()));
                downloadEl.addContent((Content)new Element("url").setText(entry.getUrl()));
                if (count > 1) {
                    downloadEl.addContent((Content)new Element("type").setText("application/atom+xml"));
                } else {
                    downloadEl.addContent((Content)new Element("type").setText(entry.getType()));
                }
                downloadEl.addContent((Content)new Element("crs").setText(entry.getCrs()));
                datasetEl.addContent((Content)downloadEl);
                downloadsCountByCrs.remove(entry.getCrs());
            }
            datasetsEl.addContent((Content)datasetEl);
        }
        return datasetsEl;
    }

    private Element buildDatasetInfo(String identifier, String namespace) {
        Element datasetEl = new Element("dataset");
        Element codeEl = new Element("code");
        codeEl.setText(identifier);
        Element namespaceEl = new Element("namespace");
        namespaceEl.setText(namespace);
        datasetEl.addContent((Content)codeEl);
        datasetEl.addContent((Content)namespaceEl);
        return datasetEl;
    }
}

