/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.InspireAtomFeedEntry;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.exceptions.ResourceNotFoundEx;
import org.fao.geonet.inspireatom.InspireAtomService;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/atom"})
@Tag(name="atom", description="ATOM")
@RestController
public class AtomGetData {
    @Autowired
    InspireAtomService service;
    @Autowired
    SettingManager sm;
    @Autowired
    DataManager dm;
    @Autowired
    InspireAtomFeedRepository inspireAtomFeedRepository;

    @Operation(summary="Get a data file related to dataset", description="This service if a dataset has only 1 download format for a CRS returns the file, otherwise returns a feed with downloads for the dataset.")
    @GetMapping(value={"/download/resource"}, produces={"application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Get a data file related to dataset"), @ApiResponse(responseCode="204", description="Not authenticated.", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Element downloadResource(@Parameter(description="spatial_dataset_identifier_code", required=true) @RequestParam String spatial_dataset_identifier_code, @Parameter(description="spatial_dataset_identifier_namespace", required=true) @RequestParam String spatial_dataset_identifier_namespace, @Parameter(description="crs", required=true) @RequestParam String crs, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext((HttpServletRequest)request);
        boolean inspireEnable = this.sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"Inspire is disabled");
            throw new Exception("Inspire is disabled");
        }
        String datasetUuid = this.service.retrieveDatasetUuidFromIdentifierNs(spatial_dataset_identifier_code, spatial_dataset_identifier_namespace);
        if (StringUtils.isEmpty((String)datasetUuid)) {
            throw new MetadataNotFoundEx(datasetUuid);
        }
        String id = this.dm.getMetadataId(datasetUuid);
        if (StringUtils.isEmpty((String)id)) {
            throw new MetadataNotFoundEx(datasetUuid);
        }
        Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        InspireAtomFeed inspireAtomFeed = this.service.findByMetadataId(Integer.parseInt(id));
        String atomUrl = inspireAtomFeed.getAtomUrl();
        if (StringUtils.isEmpty((String)atomUrl)) {
            throw new ResourceNotFoundEx("Metadata has no atom feed");
        }
        Pair<Integer, InspireAtomFeedEntry> result = this.countDatasetsForCrs(inspireAtomFeed, crs);
        int downloadCount = (Integer)result.one();
        InspireAtomFeedEntry selectedEntry = (InspireAtomFeedEntry)result.two();
        if (downloadCount == 0) {
            throw new ResourceNotFoundEx("No downloads available for dataset: " + spatial_dataset_identifier_code + " and CRS: " + crs);
        }
        if (downloadCount == 1) {
            response.setContentType(selectedEntry.getType());
            response.sendRedirect(selectedEntry.getUrl());
            return null;
        }
        Element feed = this.service.retrieveFeed(context, inspireAtomFeed);
        InspireAtomUtil.filterDatasetFeedByCrs(feed, crs);
        return feed;
    }

    private Pair<Integer, InspireAtomFeedEntry> countDatasetsForCrs(InspireAtomFeed inspireAtomFeed, String datasetCrs) {
        int downloadCount = 0;
        InspireAtomFeedEntry selectedEntry = null;
        for (InspireAtomFeedEntry entry : inspireAtomFeed.getEntryList()) {
            if (!datasetCrs.equals(entry.getCrs())) continue;
            selectedEntry = entry;
            ++downloadCount;
        }
        return Pair.write((Object)downloadCount, selectedEntry);
    }
}

