/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NodeConstraintVisitor;
import org.apache.jena.shex.expressions.NumLengthKind;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.ValidationContext;

public class NumLengthConstraint
extends NodeConstraintComponent {
    private final NumLengthKind lengthType;
    private final int length;

    public NumLengthConstraint(NumLengthKind lengthType, int len) {
        Objects.requireNonNull(lengthType);
        this.lengthType = lengthType;
        this.length = len;
    }

    public NumLengthKind getLengthType() {
        return this.lengthType;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public ReportItem nodeSatisfies(ValidationContext vCxt, Node n) {
        if (!n.isLiteral()) {
            String msg = String.format("NumericConstraint: Not numeric: %s ", ShexLib.displayStr(n));
            return new ReportItem(msg, n);
        }
        RDFDatatype rdfDT = n.getLiteralDatatype();
        if (!(rdfDT instanceof XSDDatatype)) {
            String msg = String.format("NumericConstraint: Not a numeric: %s ", ShexLib.displayStr(n));
            return new ReportItem(msg, n);
        }
        if (XSDDatatype.XSDfloat.equals(rdfDT) || XSDDatatype.XSDdouble.equals(rdfDT)) {
            String msg = String.format("NumericConstraint: Numeric not compatible with xsd:decimal: %s ", ShexLib.displayStr(n));
            return new ReportItem(msg, n);
        }
        String lexicalForm = n.getLiteralLexicalForm();
        if (!rdfDT.isValid(lexicalForm)) {
            String msg = String.format("NumericConstraint: Not a valid xsd:decimal: %s ", ShexLib.displayStr(n));
            return new ReportItem(msg, n);
        }
        String str = lexicalForm;
        int N = str.length();
        int idx = str.indexOf(46);
        switch (this.lengthType) {
            case FRACTIONDIGITS: {
                if (idx < 0) {
                    return null;
                }
                int after = str.length() - idx - 1;
                for (int i = N - 1; i > idx && str.charAt(i) == '0'; --i) {
                    --after;
                }
                if (after > this.length) break;
                return null;
            }
            case TOTALDIGITS: {
                int digits;
                int start = 0;
                char ch1 = str.charAt(0);
                if (ch1 == '+' || ch1 == '-') {
                    ++start;
                }
                for (int i = start; i < N && str.charAt(i) == '0'; ++i) {
                    ++start;
                }
                int finish = N;
                if (idx >= 0) {
                    --finish;
                    for (int i = N - 1; i > idx && str.charAt(i) == '0'; --i) {
                        --finish;
                    }
                }
                if ((digits = finish - start) > this.length) break;
                return null;
            }
        }
        String msg = String.format("Expected %s %d : got = %d", this.lengthType.label(), this.length, str.length());
        return new ReportItem(msg, n);
    }

    @Override
    public void visit(NodeConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "NumLength[" + this.lengthType.label() + " " + this.length + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.length, this.lengthType});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumLengthConstraint other = (NumLengthConstraint)obj;
        return this.length == other.length && this.lengthType == other.lengthType;
    }
}

