/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;

public class LogUtil {
    private LogUtil() {
    }

    public static String initializeHarvesterLog(String type, String name) {
        String harvesterName = name.replaceAll("\\W+", "_");
        String harvesterType = type.replaceAll("\\W+", "_");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String logfile = "harvester_" + harvesterType + "_" + harvesterName + "_" + dateFormat.format(new Date(System.currentTimeMillis())) + ".log";
        String timeZoneSetting = ((SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class)).getValue("system/server/timeZone");
        if (StringUtils.isBlank((String)timeZoneSetting)) {
            timeZoneSetting = TimeZone.getDefault().getID();
        }
        ThreadContext.put((String)"harvest", (String)harvesterName);
        ThreadContext.put((String)"logfile", (String)logfile);
        ThreadContext.put((String)"timeZone", (String)timeZoneSetting);
        try {
            return LogUtil.getHarvesterLogfilePath();
        }
        catch (Exception e) {
            Log.error((String)"Error retrieving harvester logfile path. Defaulting to base file name.", (Object)e);
            return logfile;
        }
    }

    public static String getHarvesterLogfilePath() {
        Path logDir = Paths.get(Log.getLogfile().getParent(), new String[0]);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        RoutingAppender routing = (RoutingAppender)config.getAppender("Harvester");
        if (routing == null) {
            throw new IllegalStateException("Routing appender 'Harvester' not found");
        }
        Node fileNode = routing.getRoutes().getRoutes()[0].getNode().getChildren().stream().filter(n -> "File".equalsIgnoreCase(n.getName())).findFirst().orElseThrow(() -> new IllegalStateException("No <File> node found in Harvester routes"));
        Path fullPath = Paths.get(config.getStrSubstitutor().replace((String)fileNode.getAttributes().get("fileName")), new String[0]);
        return logDir.relativize(fullPath).toString();
    }
}

