/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.url;

import java.io.Serializable;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Link;
import org.fao.geonet.domain.LinkStatus;
import org.fao.geonet.domain.Link_;
import org.fao.geonet.domain.MetadataLink;
import org.fao.geonet.domain.MetadataLink_;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.LinkAwareSchemaPlugin;
import org.fao.geonet.kernel.schema.LinkPatternStreamer.ILinkBuilder;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.kernel.url.UrlChecker;
import org.fao.geonet.repository.LinkRepository;
import org.fao.geonet.repository.LinkStatusRepository;
import org.fao.geonet.repository.MetadataLinkRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;

public class UrlAnalyzer {
    @Autowired
    protected SchemaManager schemaManager;
    @Autowired
    protected SettingManager settingManager;
    @Autowired
    protected MetadataRepository metadataRepository;
    @PersistenceContext
    protected EntityManager entityManager;
    @Autowired
    protected UrlChecker urlChecker;
    @Autowired
    protected LinkRepository linkRepository;
    @Autowired
    protected LinkStatusRepository linkStatusRepository;
    @Autowired
    protected MetadataLinkRepository metadataLinkRepository;

    public void processMetadata(Element element, AbstractMetadata md) throws JDOMException {
        SchemaPlugin schemaPlugin = this.schemaManager.getSchema(md.getDataInfo().getSchemaId()).getSchemaPlugin();
        if (schemaPlugin instanceof LinkAwareSchemaPlugin) {
            this.metadataLinkRepository.findAll(this.metadatalinksTargetting(md)).stream().forEach(metadatalink -> metadatalink.getLink().getRecords().remove(metadatalink));
            this.entityManager.flush();
            ((LinkAwareSchemaPlugin)schemaPlugin).createLinkStreamer((ILinkBuilder)new ILinkBuilder<Link, AbstractMetadata>(){

                public Link found(String url) {
                    Optional linkOptional = UrlAnalyzer.this.linkRepository.findOneByUrl(url);
                    if (linkOptional.isPresent()) {
                        return (Link)linkOptional.get();
                    }
                    Link link = new Link();
                    link.setUrl(url);
                    UrlAnalyzer.this.linkRepository.save((Object)link);
                    return link;
                }

                public void persist(Link link, AbstractMetadata metadata) {
                    MetadataLink metadataLink = new MetadataLink();
                    metadataLink.setMetadataId(Integer.valueOf(metadata.getId()));
                    metadataLink.setMetadataUuid(metadata.getUuid());
                    metadataLink.setLink(link);
                    link.getRecords().add(metadataLink);
                    UrlAnalyzer.this.linkRepository.save((Object)link);
                }
            }, this.settingManager.getValue("metadata/link/excludedUrlPattern")).processAllRawText(element, (Object)md);
            this.entityManager.flush();
        }
    }

    public void purgeMetataLink(Link link) {
        this.metadataLinkRepository.findAll(this.metadatalinksTargetting(link)).stream().filter(this::isReferencingAnUnknownMetadata).forEach(arg_0 -> ((MetadataLinkRepository)this.metadataLinkRepository).delete(arg_0));
        this.entityManager.flush();
    }

    public void deleteAll() {
        this.metadataLinkRepository.deleteAllInBatch();
        this.linkStatusRepository.deleteAllInBatch();
        this.linkRepository.deleteAllInBatch();
        this.entityManager.clear();
    }

    public void testLink(Link link) {
        LinkStatus linkStatus = this.urlChecker.getUrlStatus(link.getUrl());
        link.addStatus(linkStatus);
        this.linkRepository.save((Object)link);
    }

    private Specification<MetadataLink> metadatalinksTargetting(Link link) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)root.get(MetadataLink_.link).get(Link_.id), (Object)link.getId());
    }

    private Specification<MetadataLink> metadatalinksTargetting(AbstractMetadata md) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> criteriaBuilder.equal((Expression)root.get(MetadataLink_.metadataId), (Object)md.getId());
    }

    private boolean isReferencingAnUnknownMetadata(MetadataLink metadatalink) {
        Optional metadata = this.metadataRepository.findById((Object)metadatalink.getMetadataId());
        return metadata.isEmpty();
    }
}

