/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.shibboleth;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import jeeves.component.ProfileManager;
import org.apache.batik.util.resources.ResourceManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.kernel.security.BaseUserUtils;
import org.fao.geonet.kernel.security.GeonetworkAuthenticationProvider;
import org.fao.geonet.kernel.security.WritableUserDetailsContextMapper;
import org.fao.geonet.kernel.security.shibboleth.ShibbolethUserConfiguration;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.utils.Log;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.util.StringUtils;

public class ShibbolethUserUtils
extends BaseUserUtils {
    private UserDetailsManager userDetailsManager;
    private WritableUserDetailsContextMapper udetailsmapper;

    static MinimalUser parseUser(ServletRequest request, ResourceManager resourceManager, ProfileManager profileManager, ShibbolethUserConfiguration config) {
        return MinimalUser.create(request, config);
    }

    protected static String getHeader(HttpServletRequest req, String name, String defValue) {
        if (name == null || name.trim().isEmpty()) {
            return defValue;
        }
        String value = req.getHeader(name);
        if (value == null) {
            return defValue;
        }
        if (value.length() == 0) {
            return defValue;
        }
        return value;
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    protected UserDetails setupUser(ServletRequest request, ShibbolethUserConfiguration config) throws Exception {
        UserRepository userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        GroupRepository groupRepository = (GroupRepository)ApplicationContextHolder.get().getBean(GroupRepository.class);
        UserGroupRepository userGroupRepository = (UserGroupRepository)ApplicationContextHolder.get().getBean(UserGroupRepository.class);
        GeonetworkAuthenticationProvider authProvider = (GeonetworkAuthenticationProvider)((Object)ApplicationContextHolder.get().getBean(GeonetworkAuthenticationProvider.class));
        HttpServletRequest req = (HttpServletRequest)request;
        String username = ShibbolethUserUtils.getHeader(req, config.getUsernameKey(), "");
        String surname = ShibbolethUserUtils.getHeader(req, config.getSurnameKey(), "");
        String firstname = ShibbolethUserUtils.getHeader(req, config.getFirstnameKey(), "");
        String organisation = ShibbolethUserUtils.getHeader(req, config.getOrganisationKey(), "");
        String email = ShibbolethUserUtils.getHeader(req, config.getEmailKey(), "");
        String arraySeparator = config.getArraySeparator();
        String roleGroupSeparator = config.getRoleGroupSeparator();
        String roleGroup_header = ShibbolethUserUtils.getHeader(req, config.getRoleGroupKey(), "");
        String[] roleGroups = new String[]{};
        if (!StringUtils.isEmpty((Object)roleGroup_header)) {
            roleGroups = roleGroup_header.split(arraySeparator);
        } else {
            String profile_header = ShibbolethUserUtils.getHeader(req, config.getProfileKey(), Profile.Guest.name());
            String[] profiles = new String[]{};
            if (!StringUtils.isEmpty((Object)profile_header)) {
                profiles = profile_header.split(arraySeparator);
            }
            String group_header = ShibbolethUserUtils.getHeader(req, config.getGroupKey(), config.getDefaultGroup());
            String[] groups = new String[]{};
            if (!StringUtils.isEmpty((Object)group_header)) {
                groups = group_header.split(arraySeparator);
            }
            ArrayList<CallSite> roleGroupsList = new ArrayList<CallSite>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                String profile = profiles.length > i ? profiles[i] : Profile.Guest.toString();
                roleGroupsList.add((CallSite)((Object)(groups[i] + roleGroupSeparator + profile)));
            }
            roleGroups = (String[])roleGroupsList.stream().toArray(String[]::new);
        }
        if (!StringUtils.isEmpty((Object)username)) {
            if (username.length() > 256) {
                username = username.substring(0, 256);
            }
            User user = null;
            try {
                user = (User)authProvider.loadUserByUsername(username);
                if (config.isUpdateGroup()) {
                    this.assignGroups(groupRepository, userGroupRepository, roleGroups, roleGroupSeparator, user);
                }
                if (config.isUpdateProfile()) {
                    this.assignProfile(roleGroups, roleGroupSeparator, user);
                    userRepository.save((Object)user);
                }
            }
            catch (UsernameNotFoundException e) {
                user = new User();
                user.setUsername(username);
                user.setSurname(surname);
                user.setName(firstname);
                user.setOrganisation(organisation);
                if (!StringUtils.isEmpty((Object)email)) {
                    user.getEmailAddresses().add(email);
                }
                this.assignProfile(roleGroups, roleGroupSeparator, user);
                userRepository.save((Object)user);
                this.assignGroups(groupRepository, userGroupRepository, roleGroups, roleGroupSeparator, user);
            }
            if (this.udetailsmapper != null) {
                LDAPUser ldapUserDetails = null;
                try {
                    ldapUserDetails = (LDAPUser)this.userDetailsManager.loadUserByUsername(username);
                }
                catch (Throwable t) {
                    Log.error((String)"geonetwork", (String)("Shibboleth setupUser error: " + t.getMessage()), (Throwable)t);
                }
                if (ldapUserDetails == null) {
                    ldapUserDetails = new LDAPUser(username);
                    ldapUserDetails.getUser().setName(firstname).setSurname(surname);
                    ldapUserDetails.getUser().setOrganisation(organisation);
                    ldapUserDetails.getUser().setProfile(user.getProfile());
                    ldapUserDetails.getUser().getEmailAddresses().clear();
                    if (StringUtils.isEmpty((Object)email)) {
                        ldapUserDetails.getUser().getEmailAddresses().add(username + "@unknownIdp");
                    } else {
                        ldapUserDetails.getUser().getEmailAddresses().add(email);
                    }
                }
                this.udetailsmapper.saveUser(ldapUserDetails);
                user = ldapUserDetails.getUser();
            }
            return user;
        }
        return null;
    }

    private void assignGroups(GroupRepository groupRepository, UserGroupRepository userGroupRepository, String[] role_groups, String separator, User user) {
        HashSet<UserGroup> userGroups = new HashSet<UserGroup>();
        boolean i = false;
        for (String rg : role_groups) {
            String[] tmp = rg.split(separator);
            if (tmp.length == 0 || StringUtils.isEmpty((Object)tmp[0])) continue;
            String group = tmp[0];
            Group g = this.getOrCreateGroup(group);
            UserGroup usergroup = new UserGroup();
            usergroup.setGroup(g);
            usergroup.setUser(user);
            if (tmp.length > 1) {
                Profile profile = Profile.findProfileIgnoreCase((String)tmp[1]);
                if (profile.equals((Object)Profile.Administrator)) {
                    profile = Profile.UserAdmin;
                }
                usergroup.setProfile(profile);
                if (profile.equals((Object)Profile.Reviewer)) {
                    UserGroup ug = new UserGroup();
                    ug.setGroup(g);
                    ug.setUser(user);
                    ug.setProfile(Profile.Editor);
                    userGroups.add(ug);
                }
            } else {
                usergroup.setProfile(Profile.Guest);
            }
            userGroups.add(usergroup);
        }
        userGroupRepository.updateUserGroups(user.getId(), userGroups);
    }

    private void assignProfile(String[] role_groups, String roleGroupSeparator, User user) {
        user.setProfile(null);
        for (String rg : role_groups) {
            String[] tmp = rg.split(roleGroupSeparator);
            Profile p = Profile.findProfileIgnoreCase((String)tmp[1]);
            if (p != null && user.getProfile() == null) {
                user.setProfile(p);
                continue;
            }
            if (p == null || user.getProfile().compareTo((Enum)p) < 0) continue;
            user.setProfile(p);
        }
        if (user.getProfile() == null) {
            user.setProfile(Profile.Guest);
        }
    }

    public static class MinimalUser {
        private String username;
        private String name;
        private String surname;
        private String organisation;
        private String profile;

        static MinimalUser create(ServletRequest request, ShibbolethUserConfiguration config) {
            HttpServletRequest req = (HttpServletRequest)request;
            String username = ShibbolethUserUtils.getHeader(req, config.getUsernameKey(), "");
            String surname = ShibbolethUserUtils.getHeader(req, config.getSurnameKey(), "");
            String firstname = ShibbolethUserUtils.getHeader(req, config.getFirstnameKey(), "");
            String organisation = ShibbolethUserUtils.getHeader(req, config.getOrganisationKey(), "");
            String profile = ShibbolethUserUtils.getHeader(req, config.getProfileKey(), "");
            if (username.trim().length() > 0) {
                MinimalUser user = new MinimalUser();
                user.setUsername(username);
                user.setName(firstname);
                user.setSurname(surname);
                user.setOrganisation(organisation);
                user.setProfile(profile);
                return user;
            }
            return null;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSurname() {
            return this.surname;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }

        public String getOrganisation() {
            return this.organisation;
        }

        public void setOrganisation(String organisation) {
            this.organisation = organisation;
        }

        public String getProfile() {
            return this.profile;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }
    }
}

