/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.bearer;

import java.util.List;
import java.util.Map;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.kernel.security.openidconnect.bearer.AccessTokenValidator;
import org.springframework.beans.factory.annotation.Autowired;

public class AudienceAccessTokenValidator
implements AccessTokenValidator {
    private final String AUDIENCE_CLAIM_NAME = "aud";
    private final String APPID_CLAIM_NAME = "appid";
    private final String KEYCLOAK_AUDIENCE_CLAIM_NAME = "azp";
    @Autowired
    OIDCConfiguration oidcConfiguration;

    @Override
    public void verifyToken(Map claimsJWT, Map userInfoClaims) throws Exception {
        if (claimsJWT.get("azp") != null && claimsJWT.get("azp").equals(this.oidcConfiguration.getClientConfig().getClientId())) {
            return;
        }
        if (claimsJWT.get("appid") != null && claimsJWT.get("appid").equals(this.oidcConfiguration.getClientConfig().getClientId())) {
            return;
        }
        Object aud = claimsJWT.get("aud");
        if (aud != null) {
            if (aud instanceof String) {
                if (((String)aud).equals(this.oidcConfiguration.getClientConfig().getClientId())) {
                    return;
                }
            } else if (aud instanceof List) {
                List auds = (List)aud;
                for (Object o : auds) {
                    if (!(o instanceof String) || !o.equals(this.oidcConfiguration.getClientConfig().getClientId())) continue;
                    return;
                }
            }
        }
        throw new Exception("JWT Bearer token - probably not meant for this application");
    }
}

