/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.keycloak;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fao.geonet.Constants;
import org.fao.geonet.kernel.security.keycloak.KeycloakConfiguration;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class KeycloakLogoutSuccessHandler
implements LogoutSuccessHandler {
    @Autowired
    private KeycloakConfiguration keycloakConfiguration;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String url = request.getRequestURL().toString();
        Object redirectUrl = url.substring(0, url.length() - request.getRequestURI().length()) + request.getContextPath();
        if (this.keycloakConfiguration.getIDPLogoutUrl() != null) {
            redirectUrl = this.keycloakConfiguration.getIDPLogoutUrl().replace("{RedirecUrl}", URLEncoder.encode((String)redirectUrl, Constants.ENCODING));
            Log.debug((String)"geonetwork.security", (Object)("redirectUrl: " + (String)redirectUrl));
        }
        response.setStatus(HttpStatus.OK.value());
        response.sendRedirect((String)redirectUrl);
    }
}

