/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.jwtheaders;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.kernel.security.BaseUserUtils;
import org.fao.geonet.kernel.security.GeonetworkAuthenticationProvider;
import org.fao.geonet.kernel.security.jwtheaders.JwtHeadersConfiguration;
import org.fao.geonet.kernel.security.jwtheaders.JwtHeadersTrivialUser;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class JwtHeadersUserUtil
extends BaseUserUtils {
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    GeonetworkAuthenticationProvider authProvider;

    public User getUser(JwtHeadersTrivialUser userFromHeaders, JwtHeadersConfiguration configuration) {
        try {
            User userFromDb = (User)this.authProvider.loadUserByUsername(userFromHeaders.getUsername());
            this.injectRoles(userFromDb, userFromHeaders, configuration);
            return userFromDb;
        }
        catch (UsernameNotFoundException e) {
            return this.createUser(userFromHeaders, configuration);
        }
    }

    public void injectRoles(User userFromDb, JwtHeadersTrivialUser userFromHeaders, JwtHeadersConfiguration configuration) {
        Map<Profile, List<String>> profileGroups;
        if (configuration.isUpdateProfile()) {
            userFromDb.setProfile(userFromHeaders.getProfile());
            this.userRepository.save((Object)userFromDb);
            Log.trace((String)"geonetwork.security", (Object)String.format("JwtHeaders: existing user (%s) with profile: '%s'", userFromDb.getUsername(), userFromHeaders.getProfile()));
        }
        if (configuration.isUpdateGroup() && (profileGroups = userFromHeaders.getProfileGroups()) != null) {
            this.updateGroups(profileGroups, userFromDb);
            if (!profileGroups.isEmpty()) {
                Log.trace((String)"geonetwork.security", (Object)"JwtHeaders: existing user profile groups: ");
                for (Map.Entry<Profile, List<String>> group : profileGroups.entrySet()) {
                    Log.debug((String)"geonetwork.security", (Object)String.format("   + Profile '%s' has groups: '%s'", group.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)group.getValue())));
                }
            }
        }
    }

    public User createUser(JwtHeadersTrivialUser userFromHeaders, JwtHeadersConfiguration configuration) {
        Map<Profile, List<String>> profileGroups;
        User user = new User();
        user.setUsername(userFromHeaders.getUsername());
        if (userFromHeaders.getUsername().contains("@")) {
            user.getEmailAddresses().add(userFromHeaders.getUsername());
            user.setName(user.getUsername().substring(0, user.getUsername().indexOf("@")));
        }
        Log.debug((String)"geonetwork.security", (Object)("JwtHeaders: Creating new User in GN DB: " + user));
        if (configuration.isUpdateProfile()) {
            user.setProfile(userFromHeaders.getProfile());
            Log.debug((String)"geonetwork.security", (Object)String.format("JwtHeaders: new user profile: '%s'", userFromHeaders.getProfile()));
        } else {
            user.setProfile(Profile.RegisteredUser);
        }
        this.userRepository.save((Object)user);
        if (configuration.isUpdateGroup() && (profileGroups = userFromHeaders.getProfileGroups()) != null) {
            this.updateGroups(profileGroups, user);
            if (!profileGroups.isEmpty()) {
                Log.debug((String)"geonetwork.security", (Object)"JwtHeaders: new user profile groups: ");
                for (Map.Entry<Profile, List<String>> group : profileGroups.entrySet()) {
                    Log.debug((String)"geonetwork.security", (Object)String.format("   + Profile '%s' has groups: '%s'", group.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)group.getValue())));
                }
            }
        }
        return user;
    }

    public void updateGroups(Map<Profile, List<String>> profileGroups, User user) {
        HashSet<UserGroup> userGroups = new HashSet<UserGroup>();
        for (Profile p : profileGroups.keySet()) {
            List<String> groups = profileGroups.get(p);
            for (String rgGroup : groups) {
                Group group = this.getOrCreateGroup(rgGroup);
                UserGroup usergroup = new UserGroup();
                usergroup.setGroup(group);
                usergroup.setUser(user);
                Profile profile = p;
                if (profile.equals((Object)Profile.Administrator)) {
                    profile = Profile.UserAdmin;
                }
                usergroup.setProfile(profile);
                if (profile.equals((Object)Profile.Reviewer)) {
                    UserGroup ug = new UserGroup();
                    ug.setGroup(group);
                    ug.setUser(user);
                    ug.setProfile(Profile.Editor);
                    userGroups.add(ug);
                }
                userGroups.add(usergroup);
            }
        }
        this.userGroupRepository.updateUserGroups(user.getId(), userGroups);
    }
}

