/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.jwtheaders;

import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;

public class JwtHeadersSecurityConfig
implements SecurityProviderConfiguration {
    private String loginType = SecurityProviderConfiguration.LoginType.AUTOLOGIN.toString();
    public boolean updateProfile = true;
    public boolean updateGroup = true;

    @Override
    public String getLoginType() {
        return this.loginType;
    }

    public void setLoginType(String loginType) {
        SecurityProviderConfiguration.LoginType parsedLoginType = SecurityProviderConfiguration.LoginType.parse(loginType);
        switch (parsedLoginType) {
            case FORM: 
            case AUTOLOGIN: {
                break;
            }
            case DEFAULT: {
                parsedLoginType = SecurityProviderConfiguration.LoginType.AUTOLOGIN;
                break;
            }
            default: {
                throw new BadParameterEx("loginType", (Object)parsedLoginType.toString());
            }
        }
        this.loginType = parsedLoginType.toString();
    }

    public boolean isUpdateProfile() {
        return this.updateProfile;
    }

    public void setUpdateProfile(boolean updateProfile) {
        this.updateProfile = updateProfile;
    }

    public boolean isUpdateGroup() {
        return this.updateGroup;
    }

    public void setUpdateGroup(boolean updateGroup) {
        this.updateGroup = updateGroup;
    }

    @Override
    public String getSecurityProvider() {
        return "JWT-HEADERS";
    }

    @Override
    public boolean isUserProfileUpdateEnabled() {
        return !this.updateProfile;
    }

    @Override
    public boolean isUserGroupUpdateEnabled() {
        return !this.updateGroup;
    }
}

