/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security;

import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.User;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.util.PasswordUtil;
import org.fao.geonet.utils.Log;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class GeonetworkAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider
implements UserDetailsService {
    private boolean checkUserNameOrEmail = false;

    public boolean isCheckUserNameOrEmail() {
        return this.checkUserNameOrEmail;
    }

    public void setCheckUserNameOrEmail(boolean checkUserNameOrEmail) {
        this.checkUserNameOrEmail = checkUserNameOrEmail;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        PasswordEncoder encoder = (PasswordEncoder)ApplicationContextHolder.get().getBean(PasswordEncoder.class);
        User gnDetails = (User)userDetails;
        if (authentication.getCredentials() == null) {
            Log.warning((String)"jeeves", (Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException("Authentication failed: no credentials provided");
        }
        if (authentication.getCredentials().toString().isEmpty() || StringUtils.isEmpty((CharSequence)gnDetails.getPassword()) || !encoder.matches((CharSequence)authentication.getCredentials().toString(), gnDetails.getPassword())) {
            Log.warning((String)"jeeves", (Object)"Authentication failed: wrong password provided");
            throw new BadCredentialsException("Authentication failed: wrong password provided");
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        try {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            PasswordEncoder encoder = (PasswordEncoder)applicationContext.getBean(PasswordEncoder.class);
            UserRepository userRepository = (UserRepository)applicationContext.getBean(UserRepository.class);
            User user = userRepository.findOneByUsernameAndSecurityAuthTypeIsNullOrEmpty(username);
            if (user == null && this.checkUserNameOrEmail) {
                user = userRepository.findOneByEmailAndSecurityAuthTypeIsNullOrEmpty(username);
            }
            if (user != null) {
                if (authentication != null && authentication.getCredentials() != null && PasswordUtil.hasOldHash(user)) {
                    String oldPassword = user.getPassword();
                    String newPassword = authentication.getCredentials().toString();
                    user = PasswordUtil.updatePasswordWithNew(true, oldPassword, newPassword, user, encoder, userRepository);
                }
                return user;
            }
        }
        catch (Exception e) {
            Log.error((String)"jeeves", (String)"Unexpected error while loading user", (Throwable)e);
            throw new AuthenticationServiceException("Unexpected error while loading user", (Throwable)e);
        }
        throw new UsernameNotFoundException(username + " is not a valid username");
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.retrieveUser(username, null);
    }
}

