/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security;

import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.GroupType;
import org.fao.geonet.domain.Language;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseUserUtils {
    @Autowired
    LanguageRepository langRepository;
    @Autowired
    GroupRepository groupRepository;

    public Group getOrCreateGroup(String groupName) {
        return this.getOrCreateGroup(groupName, null);
    }

    public Group getOrCreateGroup(String groupName, GroupType newGroupType) {
        Group group = this.groupRepository.findByName(groupName);
        if (group != null && group.getType() != null && !group.getType().equals((Object)newGroupType)) {
            System.out.println("Warning: Group '" + groupName + "' exists with type '" + group.getType() + "', but requested type is '" + newGroupType + "'. Using existing group type.");
        } else if (group == null) {
            group = new Group();
            group.setName(groupName);
            if (newGroupType != null) {
                group.setType(newGroupType);
            }
            for (Language l : this.langRepository.findAll()) {
                group.getLabelTranslations().put(l.getId(), group.getName());
            }
            this.groupRepository.save((Object)group);
        }
        return group;
    }
}

