/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.util.XslUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class OverviewIndexFieldUpdater {
    private Integer imageSize = 140;
    @Autowired
    EsSearchManager searchManager;

    public void process(String uuid) {
        this.processOverview(uuid);
        this.processOverview(uuid + "-draft");
    }

    private ArrayList<HashMap<String, String>> getHitOverviews(Map<String, Object> fields) {
        Object overviews = fields.get("overview");
        if (overviews != null) {
            return (ArrayList)overviews;
        }
        return new ArrayList<HashMap<String, String>>();
    }

    private void processOverview(String id) {
        HashSet<String> source = new HashSet<String>();
        source.add("overview");
        SearchResponse response = null;
        try {
            response = this.searchManager.query(String.format("+_id:\"%s\" _exists_:overview.url -_exists_:overview.data", id), null, source, 0, 1);
            ObjectMapper objectMapper = new ObjectMapper();
            response.hits().hits().forEach(h -> {
                Hit hit = (Hit)h;
                AtomicBoolean updates = new AtomicBoolean(false);
                Map fields = (Map)objectMapper.convertValue(hit.source(), Map.class);
                this.getHitOverviews(fields).stream().forEach(overview -> {
                    String url = (String)overview.get("url");
                    if (StringUtils.isNotEmpty((String)url)) {
                        String data = XslUtil.buildDataUrl(url, this.imageSize);
                        overview.put("data", data);
                        updates.set(true);
                    }
                });
                if (updates.get()) {
                    try {
                        this.searchManager.updateFields(id, fields, (Set<String>)source);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

