/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.arcgis;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeError;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeXmlDoc;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Constants;
import org.fao.geonet.arcgis.ArcSDEConnection;
import org.fao.geonet.arcgis.ArcSDEVersionFactory;
import org.fao.geonet.utils.Log;

public class ArcSDEApiConnection
implements ArcSDEConnection {
    private SeConnection seConnection;

    public ArcSDEApiConnection(String server, int instance, String database, String username, String password) {
        try {
            this.seConnection = new SeConnection(server, instance, database, username, password);
            Log.info((String)"geonetwork.harvester.arcsde", (Object)"Connected to ArcSDE using the Java API");
            this.seConnection.setConcurrency(SeConnection.SE_LOCK_POLICY);
        }
        catch (SeException x) {
            SeError error = x.getSeError();
            String description = error.getExtError() + " " + error.getExtErrMsg() + " " + error.getErrDesc();
            Log.error((String)"geonetwork.harvester.arcsde", (String)("Error connecting to ArcSDE (via API): " + description), (Throwable)x);
            throw new ExceptionInInitializerError(x);
        }
    }

    @Override
    public void close() {
        try {
            this.seConnection.close();
        }
        catch (SeException x) {
            Log.error((String)"geonetwork.harvester.arcsde", (String)"Error closing the ArcSDE connection (via API)", (Throwable)x);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.seConnection.close();
        }
        catch (Throwable x) {
            Log.error((String)"geonetwork.harvester.arcsde", (String)"Error closing the ArcSDE connection (via API) in the finalize method", (Throwable)x);
            throw x;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Map<String, String> retrieveMetadata(AtomicBoolean cancelMonitor, String arcSDEVersion) throws Exception {
        Log.info((String)"geonetwork.harvester.arcsde", (Object)"Start retrieve metadata");
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            ArcSDEVersionFactory arcSDEVersionFactory = new ArcSDEVersionFactory();
            String metadataTable = arcSDEVersionFactory.getTableName(arcSDEVersion);
            String columnName = arcSDEVersionFactory.getMetadataColumnName(arcSDEVersion);
            SeSqlConstruct sqlConstruct = new SeSqlConstruct();
            String[] tables = new String[]{metadataTable};
            sqlConstruct.setTables(tables);
            String[] propertyNames = new String[]{columnName, "uuid"};
            SeQuery query = new SeQuery(this.seConnection);
            query.prepareQuery(propertyNames, sqlConstruct);
            query.execute();
            boolean allRowsFetched = false;
            while (!allRowsFetched) {
                if (cancelMonitor.get()) {
                    return Collections.emptyMap();
                }
                SeRow row = query.fetch();
                if (row != null) {
                    if (row.getObject(0) != null) {
                        Log.info((String)"geonetwork.harvester.arcsde", (Object)"Retrieving row metadata");
                        SeColumnDefinition colDef = row.getColumnDef(0);
                        String document = "";
                        if (colDef.getType() == 6 || colDef.getType() == 13) {
                            ByteArrayInputStream bytes = row.getBlob(0);
                            byte[] buff = new byte[bytes.available()];
                            bytes.read(buff);
                            document = new String(buff, Constants.ENCODING);
                        } else if (colDef.getType() == 10) {
                            SeXmlDoc xmlDoc = row.getXml(0);
                            document = xmlDoc.getText();
                        } else if (colDef.getType() == 5) {
                            document = row.getString(0);
                        }
                        if (!StringUtils.isNotEmpty((String)document)) continue;
                        String uuid = row.getString(1);
                        results.put(uuid, document);
                        continue;
                    }
                    Log.info((String)"geonetwork.harvester.arcsde", (Object)"Ignoring row without metadata");
                    continue;
                }
                allRowsFetched = true;
            }
            query.close();
            Log.info((String)"geonetwork.harvester.arcsde", (Object)("Finished retrieving metadata, found: #" + results.size() + " metadata records"));
            return results;
        }
        catch (SeException x) {
            SeError error = x.getSeError();
            String description = error.getExtError() + " " + error.getExtErrMsg() + " " + error.getErrDesc();
            Log.error((String)"geonetwork.harvester.arcsde", (String)("Error retrieving the metadata from ArcSDE connection (via API):" + description), (Throwable)x);
            throw new Exception(x);
        }
    }
}

