/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.doi.client;

import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.doi.client.BaseDoiClient;
import org.fao.geonet.doi.client.DoiClientException;
import org.fao.geonet.doi.client.IDoiClient;
import org.fao.geonet.utils.GeonetHttpRequestFactory;

public class DoiMedraClient
extends BaseDoiClient
implements IDoiClient {
    public static final String MEDRA_SEARCH_KEY = "medra.org";
    public static final String MEDRA_NOT_SUPPORTED_EXCEPTION_MESSAGE = "Not supported by European Registration Agency of DOI.";

    public DoiMedraClient(String apiUrl, String username, String password, String doiPublicUrl) {
        this.apiUrl = apiUrl;
        this.doiPublicUrl = StringUtils.isEmpty((CharSequence)doiPublicUrl) ? "https://doi.org/" : (doiPublicUrl.endsWith("/") ? doiPublicUrl : doiPublicUrl + "/");
        this.username = username;
        this.password = password;
        this.requestFactory = (GeonetHttpRequestFactory)ApplicationContextHolder.get().getBean(GeonetHttpRequestFactory.class);
    }

    @Override
    public void createDoi(String doi, String url) throws DoiClientException {
    }

    @Override
    public String retrieveDoi(String doi) throws DoiClientException {
        return this.retrieve(this.createPublicUrl(doi));
    }

    @Override
    public String retrieveAllDoi(String doi) throws DoiClientException {
        throw new DoiClientException(MEDRA_NOT_SUPPORTED_EXCEPTION_MESSAGE).withMessageKey("exception.doi.operationNotSupported").withDescriptionKey("exception.doi.operationNotSupported.description", new String[]{MEDRA_NOT_SUPPORTED_EXCEPTION_MESSAGE});
    }

    @Override
    public void createDoiMetadata(String doi, String doiMetadata) throws DoiClientException {
        this.create(this.apiUrl, doiMetadata, "application/xml", 200, String.format("DOI metadata registration sent to %s.", this.apiUrl));
    }

    @Override
    public String retrieveDoiMetadata(String doi) throws DoiClientException {
        return null;
    }

    @Override
    public void deleteDoiMetadata(String doi) throws DoiClientException {
    }

    @Override
    public void deleteDoi(String doi) throws DoiClientException {
    }

    @Override
    public String createUrl(String service) {
        return this.apiUrl + service;
    }

    @Override
    public String createPublicUrl(String doi) {
        return this.doiPublicUrl + doi;
    }
}

