/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.doi.client;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.DoiServer;
import org.fao.geonet.domain.Group;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataUtils;
import org.fao.geonet.repository.DoiServerRepository;
import org.fao.geonet.repository.GroupRepository;
import org.springframework.beans.factory.annotation.Autowired;

public class DoiBuilder {
    @Autowired
    GroupRepository groupRepository;

    public String create(String doiPattern, String prefix, AbstractMetadata metadata) {
        Optional groupOwner = metadata.getSourceInfo().getGroupOwner() != null ? this.groupRepository.findById((Object)metadata.getSourceInfo().getGroupOwner()) : Optional.empty();
        return prefix + "/" + doiPattern.replace("{{groupOwner}}", groupOwner.isPresent() ? ((Group)groupOwner.get()).getName() : "").replace("{{id}}", "" + metadata.getId()).replace("{{uuid}}", metadata.getUuid());
    }

    public static String createDoi(String doiServerId, String uuid) {
        if (StringUtils.isEmpty((String)doiServerId)) {
            return uuid;
        }
        DoiBuilder doiBuilder = (DoiBuilder)ApplicationContextHolder.get().getBean(DoiBuilder.class);
        DoiServerRepository doiServerRepository = (DoiServerRepository)ApplicationContextHolder.get().getBean(DoiServerRepository.class);
        Optional doiServerOpt = doiServerRepository.findOneById(Integer.parseInt(doiServerId));
        if (doiServerOpt.isPresent()) {
            String doiPrefix = ((DoiServer)doiServerOpt.get()).getPrefix();
            String doiPattern = StringUtils.defaultIfEmpty((String)((DoiServer)doiServerOpt.get()).getPattern(), (String)"{{uuid}}");
            BaseMetadataUtils metadataUtils = (BaseMetadataUtils)ApplicationContextHolder.get().getBean(BaseMetadataUtils.class);
            AbstractMetadata metadata = metadataUtils.findOneByUuid(uuid);
            return doiBuilder.create(doiPattern, doiPrefix, metadata);
        }
        return uuid;
    }
}

