/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.doi.client;

import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.doi.client.DoiClientException;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.springframework.http.client.ClientHttpResponse;

public class BaseDoiClient {
    protected String apiUrl;
    protected String doiPublicUrl;
    protected String username;
    protected String password;
    protected GeonetHttpRequestFactory requestFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void create(String url, String body, String contentType, int successStatus, String successMessage) throws DoiClientException {
        ClientHttpResponse httpResponse;
        block6: {
            httpResponse = null;
            HttpPost postMethod = null;
            try {
                Log.debug((String)"geonetwork.doi", (Object)("   -- URL: " + url));
                postMethod = new HttpPost(url);
                postMethod.addHeader((Header)new BasicHeader("Content-Type", contentType + ";charset=UTF-8"));
                Log.debug((String)"geonetwork.doi", (Object)("   -- Request body: " + body));
                StringEntity requestEntity = new StringEntity(body, contentType, "UTF-8");
                postMethod.setEntity((HttpEntity)requestEntity);
                httpResponse = this.executeRequest((HttpUriRequest)postMethod);
                int status = httpResponse.getRawStatusCode();
                Log.debug((String)"geonetwork.doi", (Object)("   -- Request status code: " + status));
                if (status != successStatus) {
                    String responseBody = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
                    String message = String.format("Failed to create '%s' with '%s'. Status is %d. Error is %s. Response body: %s", url, body, status, httpResponse.getStatusText(), responseBody);
                    Log.info((String)"geonetwork.doi", (Object)message);
                    throw new DoiClientException(String.format("Error creating DOI: %s", message)).withMessageKey("exception.doi.serverErrorCreate").withDescriptionKey("exception.doi.serverErrorCreate.description", new String[]{message});
                }
                Log.info((String)"geonetwork.doi", (Object)String.format(successMessage, url));
                if (postMethod == null) break block6;
            }
            catch (Exception ex) {
                try {
                    Log.error((String)"geonetwork.doi", (String)("   -- Error (exception): " + ex.getMessage()), (Throwable)ex);
                    throw new DoiClientException(String.format("Error creating DOI: %s", ex.getMessage())).withMessageKey("exception.doi.serverErrorCreate").withDescriptionKey("exception.doi.serverErrorCreate.description", new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    if (postMethod != null) {
                        postMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly(httpResponse);
                    throw throwable;
                }
            }
            postMethod.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
    }

    protected String retrieve(String url) throws DoiClientException {
        HttpGet getMethod;
        ClientHttpResponse httpResponse;
        block12: {
            String string;
            block13: {
                int status;
                block10: {
                    String string2;
                    block11: {
                        block8: {
                            String string3;
                            block9: {
                                httpResponse = null;
                                getMethod = null;
                                Log.debug((String)"geonetwork.doi", (Object)("   -- URL: " + url));
                                getMethod = new HttpGet(url);
                                httpResponse = this.executeRequest((HttpUriRequest)getMethod);
                                status = httpResponse.getRawStatusCode();
                                Log.debug((String)"geonetwork.doi", (Object)("   -- Request status code: " + status));
                                if (status != 200) break block8;
                                string3 = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
                                if (getMethod == null) break block9;
                                getMethod.releaseConnection();
                            }
                            IOUtils.closeQuietly((Closeable)httpResponse);
                            return string3;
                        }
                        if (status != 204) break block10;
                        string2 = null;
                        if (getMethod == null) break block11;
                        getMethod.releaseConnection();
                    }
                    IOUtils.closeQuietly((Closeable)httpResponse);
                    return string2;
                }
                if (status != 404) break block12;
                string = null;
                if (getMethod == null) break block13;
                getMethod.releaseConnection();
            }
            IOUtils.closeQuietly((Closeable)httpResponse);
            return string;
        }
        try {
            try {
                Log.info((String)"geonetwork.doi", (Object)("Retrieve DOI metadata end -- Error: " + httpResponse.getStatusText()));
                String message = httpResponse.getStatusText() + CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
                throw new DoiClientException(String.format("Error retrieving DOI: %s", message)).withMessageKey("exception.doi.serverErrorRetrieve").withDescriptionKey("exception.doi.serverErrorRetrieve.description", new String[]{message});
            }
            catch (Exception ex) {
                Log.error((String)"geonetwork.doi", (String)("   -- Error (exception): " + ex.getMessage()), (Throwable)ex);
                throw new DoiClientException(String.format("Error retrieving DOI: %s", ex.getMessage())).withMessageKey("exception.doi.serverErrorRetrieve").withDescriptionKey("exception.doi.serverErrorRetrieve.description", new String[]{ex.getMessage()});
            }
        }
        catch (Throwable throwable) {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            IOUtils.closeQuietly(httpResponse);
            throw throwable;
        }
    }

    protected ClientHttpResponse executeRequest(HttpUriRequest method) throws Exception {
        final String requestHost = method.getURI().getHost();
        Function<HttpClientBuilder, Void> requestConfiguration = new Function<HttpClientBuilder, Void>(){

            @Nullable
            public Void apply(@Nonnull HttpClientBuilder input) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(BaseDoiClient.this.username, BaseDoiClient.this.password));
                input.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                Lib.net.setupProxy((SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class), input, requestHost);
                input.useSystemProperties();
                return null;
            }
        };
        return this.requestFactory.execute(method, (Function)requestConfiguration);
    }
}

